/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.workbench;

import com.metaeffekt.artifact.analysis.flow.grpc.worker.Task;
import com.metaeffekt.artifact.analysis.workbench.TaskUtils;
import com.metaeffekt.artifact.analysis.workbench.executors.TaskExecutor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkbenchTaskQueue {
    private static final Logger log = LoggerFactory.getLogger(WorkbenchTaskQueue.class);
    private final File workbenchTasksBaseDir;
    private final File workbenchWaitingTasksDir;
    private final File workbenchPendingTasksDir;
    private final File workbenchCompletedTasksDir;
    private final List<TaskExecutor> taskExecutorList = new ArrayList<TaskExecutor>();

    public WorkbenchTaskQueue(File workbenchTasksBaseDir) {
        this.workbenchTasksBaseDir = workbenchTasksBaseDir;
        this.workbenchWaitingTasksDir = new File(workbenchTasksBaseDir, "waiting");
        this.workbenchPendingTasksDir = new File(workbenchTasksBaseDir, "pending");
        this.workbenchCompletedTasksDir = new File(workbenchTasksBaseDir, "completed");
    }

    public void startProcessing() {
        try {
            this.manageTaskFolders();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ExecutorService executor = Executors.newFixedThreadPool(1);
        executor.execute(() -> {
            block6: while (true) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    String[] waitingTaskFiles;
                    String[] stringArray = waitingTaskFiles = org.metaeffekt.core.util.FileUtils.scanDirectoryForFiles((File)this.workbenchWaitingTasksDir, (String[])new String[]{"*.task.json"});
                    int n = stringArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) continue block6;
                        String filename = stringArray[n2];
                        File waitingTaskFile = new File(this.workbenchWaitingTasksDir, filename);
                        File pendingTaskFile = new File(this.workbenchPendingTasksDir, filename);
                        File completedTaskFile = new File(this.workbenchCompletedTasksDir, filename);
                        Task task = TaskUtils.parseTask(waitingTaskFile);
                        if (task != null) {
                            this.moveFileDeleteTarget(waitingTaskFile, pendingTaskFile);
                            boolean taskProcessed = this.processTask(task);
                            if (taskProcessed) {
                                this.moveFileDeleteTarget(pendingTaskFile, completedTaskFile);
                                try {
                                    Task.Builder builder = Task.newBuilder((Task)task).setCompleted(TaskUtils.createIsoTimestamp());
                                    TaskUtils.toJsonFile(completedTaskFile, builder.build());
                                }
                                catch (Exception e) {
                                    log.warn("Cannot mark [{}] as completed.", (Object)completedTaskFile.getAbsolutePath());
                                }
                            } else {
                                this.moveFileDeleteTarget(pendingTaskFile, waitingTaskFile);
                            }
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    continue;
                }
                break;
            }
        });
    }

    private boolean processTask(Task task) {
        boolean taskProcessed = false;
        for (TaskExecutor taskExecutor : this.taskExecutorList) {
            try {
                taskProcessed |= taskExecutor.execute(task);
            }
            catch (Exception e) {
                log.warn("Cannot process task [{}] with executor [{}].", new Object[]{task.getType(), taskExecutor.getClass(), e});
            }
            if (!taskProcessed) continue;
            break;
        }
        return taskProcessed;
    }

    private void manageTaskFolders() throws IOException {
        String[] files;
        com.metaeffekt.artifact.analysis.utils.FileUtils.forceMkDirQuietly((File)this.workbenchWaitingTasksDir);
        com.metaeffekt.artifact.analysis.utils.FileUtils.forceMkDirQuietly((File)this.workbenchPendingTasksDir);
        com.metaeffekt.artifact.analysis.utils.FileUtils.forceMkDirQuietly((File)this.workbenchCompletedTasksDir);
        org.metaeffekt.core.util.FileUtils.validateExists((File)this.workbenchWaitingTasksDir);
        org.metaeffekt.core.util.FileUtils.validateExists((File)this.workbenchPendingTasksDir);
        org.metaeffekt.core.util.FileUtils.validateExists((File)this.workbenchCompletedTasksDir);
        for (String filename : files = org.metaeffekt.core.util.FileUtils.scanDirectoryForFiles((File)this.workbenchPendingTasksDir, (String[])new String[]{"*.task.json"})) {
            File taskFile = new File(this.workbenchPendingTasksDir, filename);
            File destFile = new File(this.workbenchWaitingTasksDir, filename);
            this.moveFileDeleteTarget(taskFile, destFile);
        }
    }

    private void moveFileDeleteTarget(File taskFile, File destFile) throws IOException {
        if (destFile.exists()) {
            com.metaeffekt.artifact.analysis.utils.FileUtils.forceDelete((File)destFile);
        }
        FileUtils.moveFile((File)taskFile, (File)destFile);
    }

    public void add(TaskExecutor taskExecutor) {
        this.taskExecutorList.add(taskExecutor);
    }

    public void schedule(Task task) throws IOException {
        log.info("Scheduled local [{}] task [{}].", (Object)task.getType(), (Object)task.getId());
        TaskUtils.toJsonFile(new File(this.getWorkbenchWaitingTasksDir(), task.getId() + ".task.json"), task);
    }

    public File getWorkbenchTasksBaseDir() {
        return this.workbenchTasksBaseDir;
    }

    public File getWorkbenchWaitingTasksDir() {
        return this.workbenchWaitingTasksDir;
    }

    public File getWorkbenchPendingTasksDir() {
        return this.workbenchPendingTasksDir;
    }

    public File getWorkbenchCompletedTasksDir() {
        return this.workbenchCompletedTasksDir;
    }
}

