/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.workbench.executors;

import com.metaeffekt.artifact.analysis.flow.AttachReportFlow;
import com.metaeffekt.artifact.analysis.flow.FormatInventoryFlow;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.FileLocation;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.ReportInventoryParams;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.Task;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.TaskType;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.InventoryUtils;
import com.metaeffekt.artifact.analysis.workbench.ProjectInventoryFilter;
import com.metaeffekt.artifact.analysis.workbench.executors.TaskExecutor;
import com.metaeffekt.resource.InventoryResource;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.metaeffekt.core.inventory.InventoryMergeUtils;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.InventoryInfo;
import org.metaeffekt.core.inventory.processor.reader.InventoryReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverallReportTaskExecutor
implements TaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(OverallReportTaskExecutor.class);
    public static final int ONE_SECOND = 1000;
    private final AttachReportFlow attachReportFlow = new AttachReportFlow();
    private final FormatInventoryFlow formatInventoryFlow = new FormatInventoryFlow();
    private final InventoryResource referenceInventoryResource;

    public OverallReportTaskExecutor(InventoryResource referenceInventoryResource) {
        this.referenceInventoryResource = referenceInventoryResource;
    }

    @Override
    public boolean execute(Task task) throws Exception {
        if (TaskType.OVERALL_REPORT.equals((Object)task.getType())) {
            ReportInventoryParams reportInventoryParams = task.getReportInventory();
            String inputBaseDirPath = reportInventoryParams.getInBaseDir();
            FileLocation outFile = reportInventoryParams.getOutFile();
            Map paramsMap = reportInventoryParams.getParamsMap();
            File outputInventoryFile = new File(outFile.getBaseDir(), outFile.getRelativePath());
            long startReportTimestamp = System.currentTimeMillis();
            File inputBaseDir = new File(inputBaseDirPath);
            if (inputBaseDir.exists()) {
                this.logExecutionStarted(log, task);
                Inventory referenceInventory = this.referenceInventoryResource.reloadInventory();
                List<File> inputInventoryList = OverallReportTaskExecutor.scanForValidatedOrReportedInventories(inputBaseDir);
                Inventory targetInventory = this.modulateAndMergeInventories(inputInventoryList);
                InventoryInfo info = new InventoryInfo();
                info.set(InventoryInfo.Attribute.ID, "Overall Report");
                for (Map.Entry entry : paramsMap.entrySet()) {
                    info.set((String)entry.getKey(), (String)entry.getValue());
                    targetInventory.getInventoryInfo().add(info);
                }
                ProjectInventoryFilter projectInventoryFilter = new ProjectInventoryFilter();
                projectInventoryFilter.setEnableApplyCurationData(true);
                projectInventoryFilter.process(targetInventory, referenceInventory);
                InventoryResource targetInventoryResource = InventoryResource.fromInventory((Inventory)targetInventory);
                this.attachReportFlow.attachReport(targetInventoryResource);
                this.formatInventoryFlow.filterAndFormat(targetInventoryResource);
                FileUtils.forceMkdirParent((File)outputInventoryFile);
                targetInventoryResource.sync(outputInventoryFile);
                outputInventoryFile.setLastModified(startReportTimestamp);
                this.logExecutionCompleted(log, task);
                return true;
            }
        }
        return false;
    }

    private Inventory modulateAndMergeInventories(List<File> inputInventoryList) throws IOException {
        Inventory targetInventory = new Inventory();
        InventoryMergeUtils inventoryMergeUtils = new InventoryMergeUtils();
        for (File inventoryFile : inputInventoryList) {
            Inventory sourceInventory = new InventoryReader().readInventory(inventoryFile);
            Set assetIds = InventoryUtils.collectAssetIdsFromArtifacts((Inventory)sourceInventory);
            for (String assetId : assetIds) {
                InventoryUtils.removeAssetAttribute((String)assetId, (Inventory)sourceInventory);
            }
            InventoryUtils.removeAssetsAndReferences((Inventory)sourceInventory);
            sourceInventory.getLicenseData().clear();
            sourceInventory.getLicenseMetaData().clear();
            sourceInventory.getReportData().clear();
            sourceInventory.getAdvisoryMetaData().clear();
            sourceInventory.getAssetMetaData().clear();
            String sourceAssetId = this.deriveAssetId(inventoryFile);
            sourceInventory.getArtifacts().forEach(a -> a.set(sourceAssetId, "x"));
            inventoryMergeUtils.mergeInventories(Collections.singletonList(sourceInventory), targetInventory);
        }
        targetInventory.mergeDuplicates();
        return targetInventory;
    }

    private String deriveAssetId(File inventoryFile) {
        String sourceAssetRef = inventoryFile.getName();
        sourceAssetRef = sourceAssetRef.substring(0, sourceAssetRef.lastIndexOf("_"));
        sourceAssetRef = sourceAssetRef.replace("_", ":");
        String sourceAssetGroupVersion = inventoryFile.getParentFile().getName();
        String sourceAssetGroupName = inventoryFile.getParentFile().getParentFile().getName();
        String sourceAssetProjectName = inventoryFile.getParentFile().getParentFile().getParentFile().getName();
        return "AID-" + sourceAssetProjectName + "-" + sourceAssetGroupName + ":" + sourceAssetGroupVersion + "-" + sourceAssetRef;
    }

    public static List<File> scanForValidatedOrReportedInventories(File inputBaseDir) {
        String[] validatedInventoryFiles = FileUtils.scanDirectoryForFiles((File)inputBaseDir, (String[])new String[]{"**/*_validated.xlsx"});
        ArrayList<File> inputInventoryList = new ArrayList<File>();
        for (String validatedInventoryFilePath : validatedInventoryFiles) {
            File validatedInventoryFile = new File(inputBaseDir, validatedInventoryFilePath);
            String reportedInventoryPath = validatedInventoryFilePath.replace("_validated.xlsx", "_report.xlsx");
            File reportedInventoryFile = new File(inputBaseDir, reportedInventoryPath);
            File inputInventoryFile = reportedInventoryFile.exists() ? reportedInventoryFile : validatedInventoryFile;
            inputInventoryList.add(inputInventoryFile);
        }
        return inputInventoryList;
    }

    public static List<File> filterByTimestamp(List<File> files, long referenceTimestamp) {
        ArrayList<File> filteredFiles = new ArrayList<File>();
        for (File file : files) {
            if (file.lastModified() < referenceTimestamp) continue;
            filteredFiles.add(file);
        }
        return filteredFiles;
    }
}

