/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.workbench.executors;

import com.metaeffekt.artifact.analysis.flow.grpc.worker.FileLocation;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.PushResponse;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.Task;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.TaskType;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.TransferInventoryParams;
import com.metaeffekt.artifact.analysis.workbench.TaskUtils;
import com.metaeffekt.artifact.analysis.workbench.executors.TaskExecutor;
import com.metaeffekt.artifact.analysis.workbench.grpc.WorkerClient;
import java.io.File;
import java.util.UUID;

public class PrepareTransferTaskExecutor
implements TaskExecutor {
    private final WorkerClient controlWorkerClient;

    public PrepareTransferTaskExecutor(WorkerClient controlWorkerClient) {
        this.controlWorkerClient = controlWorkerClient;
    }

    @Override
    public boolean execute(Task task) throws Exception {
        if (TaskType.PREPARE_TRANSFER.equals((Object)task.getType())) {
            FileLocation inFile = task.getInputOutput().getInFile();
            FileLocation outFile = task.getInputOutput().getOutFile();
            File localFile = new File(inFile.getBaseDir(), inFile.getRelativePath());
            if (!localFile.exists()) {
                return false;
            }
            com.metaeffekt.artifact.analysis.flow.grpc.worker.File remoteFile = com.metaeffekt.artifact.analysis.flow.grpc.worker.File.newBuilder().setLocation(TaskUtils.createFileLocation(outFile.getBaseDir(), outFile.getRelativePath())).setBased64Content(TaskUtils.toBase64EncodedString(localFile)).build();
            TransferInventoryParams transferInventory = TransferInventoryParams.newBuilder().setFile(remoteFile).build();
            Task remoteTask = Task.newBuilder().setType(TaskType.TRANSFER).setId(UUID.randomUUID().toString()).setTransferInventory(transferInventory).setCreated(TaskUtils.createIsoTimestamp()).build();
            PushResponse push = this.controlWorkerClient.push(remoteTask);
            return push.getCode() == 0;
        }
        return false;
    }
}

