/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.workbench.executors;

import com.metaeffekt.artifact.analysis.flow.ScanFlow;
import com.metaeffekt.artifact.analysis.flow.ScanFlowParam;
import com.metaeffekt.artifact.analysis.flow.ScanFlowResult;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.FileInputOutputParams;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.FileLocation;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.Task;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.TaskType;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.workbench.executors.TaskExecutor;
import com.metaeffekt.resource.InventoryResource;
import java.io.File;
import org.metaeffekt.core.inventory.processor.model.Inventory;

public class ScanTaskExecutor
implements TaskExecutor {
    private final ScanFlow scanFlow = new ScanFlow();
    private final ScanFlowParam scanFlowParamTemplate;

    public ScanTaskExecutor(ScanFlowParam scanFlowParamTemplate) {
        this.scanFlowParamTemplate = scanFlowParamTemplate;
    }

    @Override
    public boolean execute(Task task) throws Exception {
        if (TaskType.SCAN.equals((Object)task.getType())) {
            FileInputOutputParams scanInventory = task.getInputOutput();
            FileLocation inFile = scanInventory.getInFile();
            FileLocation outFile = scanInventory.getOutFile();
            File inputInventoryFile = new File(inFile.getBaseDir(), inFile.getRelativePath());
            File outputInventoryFile = new File(outFile.getBaseDir(), outFile.getRelativePath());
            if (inputInventoryFile.exists()) {
                ScanFlowParam scanFlowParam = ScanFlowParam.copy(this.scanFlowParamTemplate);
                scanFlowParam.withInventory(InventoryResource.fromFile((File)inputInventoryFile));
                ScanFlowResult process = this.scanFlow.process(scanFlowParam);
                if (process != null) {
                    FileUtils.forceMkdirParent((File)outputInventoryFile);
                    InventoryResource.fromInventory((Inventory)process.getInventory()).sync(outputInventoryFile);
                    return true;
                }
            }
        }
        return false;
    }
}

