/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.workbench.grpc;

import com.metaeffekt.artifact.analysis.flow.grpc.worker.PushResponse;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.Task;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.WorkerGrpc;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.Grpc;
import io.grpc.InsecureChannelCredentials;
import io.grpc.ManagedChannel;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerClient {
    private static final Logger log = LoggerFactory.getLogger(WorkerClient.class);
    private ManagedChannel managedChannel;
    private WorkerGrpc.WorkerBlockingStub stub;
    private String targetEndpoint;

    public void initialize(String host, String port) {
        this.targetEndpoint = host + ":" + port;
        ChannelCredentials credentials = InsecureChannelCredentials.create();
        this.managedChannel = Grpc.newChannelBuilder((String)this.targetEndpoint, (ChannelCredentials)credentials).build();
        try {
            this.stub = WorkerGrpc.newBlockingStub((Channel)this.managedChannel);
        }
        catch (Exception e) {
            this.close(this.managedChannel);
        }
    }

    private void close(ManagedChannel channel) {
        try {
            channel.shutdownNow().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void close() {
        if (this.managedChannel != null) {
            this.close(this.managedChannel);
            this.managedChannel = null;
        }
    }

    public PushResponse push(Task task) {
        log.info("Pushing [{}] task [{}] to worker [{}].", new Object[]{task.getType(), task.getId(), this.targetEndpoint});
        return this.stub.push(task);
    }
}

