/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.workbench.grpc;

import com.metaeffekt.artifact.analysis.flow.grpc.worker.FileInputOutputParams;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.FileLocation;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.PushResponse;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.Task;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.TaskType;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.WorkerGrpc;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.workbench.TaskUtils;
import com.metaeffekt.artifact.analysis.workbench.WorkbenchTaskQueue;
import io.grpc.BindableService;
import io.grpc.Grpc;
import io.grpc.InsecureServerCredentials;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.stub.StreamObserver;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerServer
extends WorkerGrpc.WorkerImplBase {
    private static final Logger log = LoggerFactory.getLogger(WorkerServer.class);
    private int port;
    private File workerBaseDir;
    private WorkbenchTaskQueue workbenchTaskQueue;
    private Server server;

    public void initialize(int port, File workerBaseDir, WorkbenchTaskQueue workbenchTaskQueue) {
        this.port = port;
        this.workerBaseDir = workerBaseDir;
        this.workbenchTaskQueue = workbenchTaskQueue;
    }

    public void push(Task task, StreamObserver<PushResponse> responseObserver) {
        log.info("Received [{}] task [{}].", (Object)task.getType(), (Object)task.getId());
        if (task.hasProcessInventory()) {
            File localBaseDir = new File(this.workerBaseDir, task.getType().toString());
            com.metaeffekt.artifact.analysis.flow.grpc.worker.File file = task.getProcessInventory().getFile();
            String localRelativePath = file.getLocation().getRelativePath();
            File localFile = new File(localBaseDir, localRelativePath);
            try {
                FileUtils.forceMkdirParent((File)localFile);
                FileUtils.writeByteArrayToFile((File)localFile, (byte[])Base64.decode((String)file.getBased64Content()));
                this.scheduleResolveTask(localBaseDir, localRelativePath);
                this.scheduleScanTask(localBaseDir, localRelativePath);
                this.schedulePrepareTransferTask(localBaseDir, localRelativePath, task);
                this.createPushResponse(responseObserver, 0, "ACCEPTED - " + task.getId());
            }
            catch (IOException e) {
                this.createPushResponse(responseObserver, 1, "FAILURE: " + e.getMessage());
            }
        } else if (task.hasTransferInventory()) {
            try {
                com.metaeffekt.artifact.analysis.flow.grpc.worker.File file = task.getTransferInventory().getFile();
                FileLocation fileLocation = file.getLocation();
                File targetFile = new File(fileLocation.getBaseDir(), fileLocation.getRelativePath());
                FileUtils.writeByteArrayToFile((File)targetFile, (byte[])Base64.decode((String)file.getBased64Content()));
                this.scheduleReportTask(new File(fileLocation.getBaseDir()), fileLocation.getRelativePath());
                this.createPushResponse(responseObserver, 0, "ACCEPTED - " + task.getId());
            }
            catch (IOException e) {
                this.createPushResponse(responseObserver, 1, "FAILURE: " + e.getMessage());
            }
        } else {
            this.createPushResponse(responseObserver, 2, "REJECTED - " + task.getType() + ": not accepting " + task.getType() + " tasks from remote.");
        }
    }

    private void scheduleResolveTask(File localBaseDir, String validatedInventoryName) {
        String resolvedInventoryRelativePath = validatedInventoryName.replace("_validated.xlsx", "_resolved.xlsx");
        this.deleteTargetFileIfExists(localBaseDir, resolvedInventoryRelativePath);
        FileInputOutputParams resolveInventoryParams = FileInputOutputParams.newBuilder().setInFile(TaskUtils.createFileLocation(localBaseDir.getAbsolutePath(), validatedInventoryName)).setOutFile(TaskUtils.createFileLocation(localBaseDir.getAbsolutePath(), resolvedInventoryRelativePath)).build();
        Task task = Task.newBuilder().setType(TaskType.RESOLVE).setId(UUID.randomUUID().toString()).setCreated(TaskUtils.createIsoTimestamp()).setInputOutput(resolveInventoryParams).build();
        try {
            this.workbenchTaskQueue.schedule(task);
        }
        catch (IOException e) {
            log.warn("Cannot schedule resolver task.", (Throwable)e);
        }
    }

    private void scheduleScanTask(File localBaseDir, String validatedInventoryRelativePath) {
        String resolvedInventoryRelativePath = validatedInventoryRelativePath.replace("_validated.xlsx", "_resolved.xlsx");
        String scannedInventoryRelativePath = validatedInventoryRelativePath.replace("_validated.xlsx", "_scanned.xlsx");
        this.deleteTargetFileIfExists(localBaseDir, scannedInventoryRelativePath);
        FileInputOutputParams fileInputOutputParams = FileInputOutputParams.newBuilder().setInFile(TaskUtils.createFileLocation(localBaseDir.getAbsolutePath(), resolvedInventoryRelativePath)).setOutFile(TaskUtils.createFileLocation(localBaseDir.getAbsolutePath(), scannedInventoryRelativePath)).build();
        Task task = Task.newBuilder().setType(TaskType.SCAN).setId(UUID.randomUUID().toString()).setCreated(TaskUtils.createIsoTimestamp()).setInputOutput(fileInputOutputParams).build();
        try {
            this.workbenchTaskQueue.schedule(task);
        }
        catch (IOException e) {
            log.warn("Cannot schedule resolver task.", (Throwable)e);
        }
    }

    private void schedulePrepareTransferTask(File localBaseDir, String validatedInventoryRelativePath, Task originalTask) {
        try {
            String scannedInventoryRelativePath = validatedInventoryRelativePath.replace("_validated.xlsx", "_scanned.xlsx");
            FileLocation originalLocationOnSourceSystem = originalTask.getProcessInventory().getFile().getLocation();
            FileInputOutputParams transferInventoryParams = FileInputOutputParams.newBuilder().setInFile(TaskUtils.createFileLocation(localBaseDir.getAbsolutePath(), scannedInventoryRelativePath)).setOutFile(TaskUtils.createFileLocation(originalLocationOnSourceSystem.getBaseDir(), scannedInventoryRelativePath)).build();
            Task task = Task.newBuilder().setType(TaskType.PREPARE_TRANSFER).setId(UUID.randomUUID().toString()).setCreated(TaskUtils.createIsoTimestamp()).setInputOutput(transferInventoryParams).build();
            this.workbenchTaskQueue.schedule(task);
        }
        catch (IOException e) {
            log.warn("Cannot schedule resolver task.", (Throwable)e);
        }
    }

    private void scheduleReportTask(File localBaseDir, String scannedInventoryRelativePath) {
        String reportedInventoryRelativePath = scannedInventoryRelativePath.replace("_scanned.xlsx", "_report.xlsx");
        this.deleteTargetFileIfExists(localBaseDir, reportedInventoryRelativePath);
        FileInputOutputParams reportInventoryParams = FileInputOutputParams.newBuilder().setInFile(TaskUtils.createFileLocation(localBaseDir.getAbsolutePath(), scannedInventoryRelativePath)).setOutFile(TaskUtils.createFileLocation(localBaseDir.getAbsolutePath(), reportedInventoryRelativePath)).build();
        Task task = Task.newBuilder().setType(TaskType.REPORT).setId(UUID.randomUUID().toString()).setCreated(TaskUtils.createIsoTimestamp()).setInputOutput(reportInventoryParams).build();
        try {
            this.workbenchTaskQueue.schedule(task);
        }
        catch (IOException e) {
            log.warn("Cannot schedule resolver task.", (Throwable)e);
        }
    }

    private void deleteTargetFileIfExists(File localBaseDir, String relativePath) {
        File file = new File(localBaseDir, relativePath);
        if (file.exists()) {
            FileUtils.deleteQuietly((File)file);
        }
    }

    private void createPushResponse(StreamObserver<PushResponse> responseObserver, int code, String message) {
        PushResponse.Builder pushResponse = PushResponse.newBuilder().setCode(code).setMessage(message);
        responseObserver.onNext((Object)pushResponse.build());
        responseObserver.onCompleted();
    }

    private void start() throws IOException {
        ServerCredentials credentials = InsecureServerCredentials.create();
        this.server = Grpc.newServerBuilderForPort((int)this.port, (ServerCredentials)credentials).addService((BindableService)this).build();
        this.server.start();
        log.info("Worker started, listening on [{}]", (Object)this.port);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("Shutting down worker...");
                try {
                    WorkerServer.this.stop();
                }
                catch (InterruptedException e) {
                    e.printStackTrace(System.out);
                }
                System.out.println("Shutting down worker server completed.");
            }
        });
    }

    private void stop() throws InterruptedException {
        if (this.server != null) {
            this.server.shutdown().awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    public void startBlocking() {
        try {
            this.start();
            if (this.server != null) {
                this.server.awaitTermination();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

