/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow;

import com.metaeffekt.artifact.analysis.flow.grpc.worker.TaskType;
import com.metaeffekt.artifact.analysis.utils.InventoryUtils;
import com.metaeffekt.resource.InventoryResource;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.InventorySerializationContext;

public class FormatInventoryFlow {
    public void filterAndFormat(InventoryResource inventoryResource) {
        Inventory inventory = inventoryResource.getInventory();
        InventoryUtils.renameArtifactAttributes((Inventory)inventory, (String)"Vendor", (String)"Organization");
        InventoryUtils.renameArtifactAttributes((Inventory)inventory, (String)"Vendor URL", (String)"Organization URL");
        InventoryUtils.renameArtifactAttributes((Inventory)inventory, (String)"Checksum", (String)"Checksum (MD5)");
        InventoryUtils.renameArtifactAttributes((Inventory)inventory, (String)"Content MD5", (String)"Content Checksum (MD5)");
        InventoryUtils.renameArtifactAttributes((Inventory)inventory, (String)"Checksum (SHA-1)", (String)"Hash (SHA-1)");
        InventoryUtils.renameArtifactAttributes((Inventory)inventory, (String)"Alpine Group", (String)"Package Group");
        InventoryUtils.renameArtifactAttributes((Inventory)inventory, (String)"Specified Package License", (String)"Package Specified License");
        InventoryUtils.renameArtifactAttributes((Inventory)inventory, (String)"Specified Package License (mapped)", (String)"Package Specified License (mapped)");
        InventoryUtils.renameArtifactAttributes((Inventory)inventory, (String)"Specified Package License (unknown)", (String)"Package Specified License (unknown)");
        InventoryUtils.renameArtifactAttributes((Inventory)inventory, (String)"Component Source Type", (String)"Specific Type");
        InventoryUtils.removeAssetAttribute((String)"meta_LastTagTime", (Inventory)inventory);
        InventoryUtils.removeArtifactInheritedAttributes((Inventory)inventory);
        inventory.getArtifacts().sort(Comparator.comparing(InventoryUtils::createStringRepresentation));
        inventory.getLicenseData().sort(Comparator.comparing(InventoryUtils::createStringRepresentation));
        inventory.getAssetMetaData().sort(Comparator.comparing(InventoryUtils::createStringRepresentation));
        InventorySerializationContext.initializeArtifactSerializationContext((Inventory)inventory);
        InventorySerializationContext serializationContext = inventory.getSerializationContext();
        List artifactColumnList = (List)serializationContext.get("artifact.columnlist");
        List licenseDataColumnList = InventorySerializationContext.initializeLicenseDataSerializationContext((Inventory)inventory);
        this.insertItem(artifactColumnList, "Id", "Checksum (MD5)", 1);
        this.insertItem(artifactColumnList, "Checksum (MD5)", "Hash (SHA-1)", 1);
        this.insertItem(artifactColumnList, "Content Checksum (MD5)", "Hash (SHA-256)", 1);
        this.insertItem(artifactColumnList, "Content Checksum (MD5)", "Hash (SHA-1)", 1);
        this.insertItem(artifactColumnList, "Hash (SHA-1)", "Hash (SHA-256)", 1);
        this.insertItem(artifactColumnList, "Analysis Path", "Source - Analysis Path", 1);
        this.insertItem(artifactColumnList, "Source - Archive Path", "Archive Path", 0);
        if (!artifactColumnList.contains("Notice Parameter")) {
            artifactColumnList.add("Notice Parameter");
        }
        if (!artifactColumnList.contains("Classification")) {
            artifactColumnList.add("Classification");
        }
        this.insertItem(artifactColumnList, "Version", "Architecture", 1);
        this.insertItem(artifactColumnList, "Version", "License", 1);
        this.insertItem(artifactColumnList, "License", "Notice Parameter", 1);
        this.insertItem(artifactColumnList, "Notice Parameter", "Classification", 1);
        this.insertItem(artifactColumnList, "Classification", "Rationale", 1);
        this.insertItem(artifactColumnList, "Rationale", "Summary", 1);
        this.insertItem(artifactColumnList, "Rationale", "Description", 1);
        this.insertItem(artifactColumnList, "Package Documentation Path", "Package Group", 0);
        this.insertItem(artifactColumnList, "Archive Path", "Analysis Path", 1);
        this.insertItem(artifactColumnList, "Analysis Path", "Result Path", 1);
        this.insertItem(artifactColumnList, "Result Path", "Derived Licenses", 1);
        this.insertItem(artifactColumnList, "Derived Licenses", "Derived Markers", 1);
        this.insertItem(artifactColumnList, "Derived Markers", "Derived Licenses (ScanCode)", 1);
        this.insertItem(artifactColumnList, "Derived Licenses (ScanCode)", "Extracted Copyrights (ScanCode)", 1);
        this.insertItem(artifactColumnList, "Type", "Errors", 1);
        this.insertItem(artifactColumnList, "Errors", "Incomplete Match", 1);
        int i = 0;
        for (String attribute : new ArrayList(artifactColumnList)) {
            if (attribute.startsWith("EID-")) {
                this.insertItem(artifactColumnList, "Analysis Path", attribute, 1 + i);
                this.insertItem(artifactColumnList, attribute, "Summary", 1);
                ++i;
            }
            if (!attribute.startsWith("AID-")) continue;
            artifactColumnList.remove(attribute);
        }
        this.moveToEndColumn(artifactColumnList, "Path in Asset");
        this.moveToEndColumn(artifactColumnList, "Identified Terms");
        this.moveToEndColumn(artifactColumnList, "Organization");
        this.moveToEndColumn(artifactColumnList, "Organization Id");
        this.moveToEndColumn(artifactColumnList, "Packaging");
        this.moveToEndColumns(artifactColumnList, "Derived ");
        this.moveToEndColumn(artifactColumnList, "Extracted Copyrights (ScanCode)");
        this.moveToEndColumn(artifactColumnList, "Extracted Authors (ScanCode)");
        for (int j = 0; j < artifactColumnList.size(); ++j) {
            String column = (String)artifactColumnList.get(j);
            if (!column.startsWith("Binary Artifact - ") && !column.startsWith("Source Artifact - ") && !column.startsWith("Source Archive - ") && !column.startsWith("Descriptor - ")) continue;
            artifactColumnList.remove(j);
            --j;
        }
        this.insertItem(licenseDataColumnList, "Kommentare", "Nutzung mit Ber\u00fccksichtigung unwesentlicher Einschr\u00e4nkungen", 1);
        this.insertItem(licenseDataColumnList, "Kommentare", "Nutzung mit Ber\u00fccksichtigung wesentlicher Einschr\u00e4nkungen", 1);
        this.insertItem(licenseDataColumnList, "Kommentare", "Nutzung nur mit zus\u00e4tzlichen Services", 1);
        this.insertItem(licenseDataColumnList, "Kommentare", "Keine Nutzung m\u00f6glich", 1);
        this.insertItem(licenseDataColumnList, "Kommentare", "Assessment Pending", 1);
        this.insertItem(licenseDataColumnList, "Keine Nutzung m\u00f6glich", "Nutzung nur mit zus\u00e4tzlichen Services", 1);
        this.insertItem(licenseDataColumnList, "Nutzung nur mit zus\u00e4tzlichen Services", "Nutzung mit Ber\u00fccksichtigung wesentlicher Einschr\u00e4nkungen", 1);
        this.insertItem(licenseDataColumnList, "Nutzung mit Ber\u00fccksichtigung wesentlicher Einschr\u00e4nkungen", "Nutzung mit Ber\u00fccksichtigung unwesentlicher Einschr\u00e4nkungen", 1);
        this.insertItem(licenseDataColumnList, "Nutzung mit Ber\u00fccksichtigung unwesentlicher Einschr\u00e4nkungen", "Assessment Pending", 1);
        this.insertItem(licenseDataColumnList, "SPDX Id", "ScanCode Ids", 1);
        this.insertItem(licenseDataColumnList, "ScanCode Ids", "OSI Status", 1);
        this.insertItem(licenseDataColumnList, "OSI Status", "Open CoDE Status", 1);
        if (licenseDataColumnList.contains("Commercial")) {
            this.insertItem(licenseDataColumnList, "Open CoDE Status", "Commercial", 1);
        }
        if (licenseDataColumnList.contains("(Red Hat Only)")) {
            this.insertItem(licenseDataColumnList, "Open CoDE Status", "(Red Hat Only)", 1);
        }
        serializationContext.put("licensedata.header.[Keine Nutzung m\u00f6glich].fg", (Object)"248,203,173");
        serializationContext.put("licensedata.header.[Keine Nutzung m\u00f6glich].orientation", (Object)"up");
        serializationContext.put("licensedata.header.[Keine Nutzung m\u00f6glich].width", (Object)42);
        serializationContext.put("licensedata.column.[Keine Nutzung m\u00f6glich].centered", (Object)true);
        serializationContext.put("licensedata.header.[Nutzung nur mit zus\u00e4tzlichen Services].fg", (Object)"255,230,153");
        serializationContext.put("licensedata.header.[Nutzung nur mit zus\u00e4tzlichen Services].orientation", (Object)"up");
        serializationContext.put("licensedata.header.[Nutzung nur mit zus\u00e4tzlichen Services].width", (Object)42);
        serializationContext.put("licensedata.column.[Nutzung nur mit zus\u00e4tzlichen Services].centered", (Object)true);
        serializationContext.put("licensedata.header.[Nutzung mit Ber\u00fccksichtigung wesentlicher Einschr\u00e4nkungen].fg", (Object)"226,239,218");
        serializationContext.put("licensedata.header.[Nutzung mit Ber\u00fccksichtigung wesentlicher Einschr\u00e4nkungen].orientation", (Object)"up");
        serializationContext.put("licensedata.header.[Nutzung mit Ber\u00fccksichtigung wesentlicher Einschr\u00e4nkungen].width", (Object)42);
        serializationContext.put("licensedata.column.[Nutzung mit Ber\u00fccksichtigung wesentlicher Einschr\u00e4nkungen].centered", (Object)true);
        serializationContext.put("licensedata.header.[Nutzung mit Ber\u00fccksichtigung unwesentlicher Einschr\u00e4nkungen].fg", (Object)"198,224,180");
        serializationContext.put("licensedata.header.[Nutzung mit Ber\u00fccksichtigung unwesentlicher Einschr\u00e4nkungen].orientation", (Object)"up");
        serializationContext.put("licensedata.header.[Nutzung mit Ber\u00fccksichtigung unwesentlicher Einschr\u00e4nkungen].width", (Object)42);
        serializationContext.put("licensedata.column.[Nutzung mit Ber\u00fccksichtigung unwesentlicher Einschr\u00e4nkungen].centered", (Object)true);
        serializationContext.put("licensedata.header.[OSI Approved].fg", (Object)"221,235,247");
        serializationContext.put("licensedata.header.[OSI Approved].orientation", (Object)"up");
        serializationContext.put("licensedata.header.[OSI Approved].width", (Object)42);
        serializationContext.put("licensedata.column.[OSI Approved].centered", (Object)true);
        serializationContext.put("licensedata.header.[OSI Status].fg", (Object)"221,235,247");
        serializationContext.put("licensedata.header.[OSI Status].orientation", (Object)"up");
        serializationContext.put("licensedata.header.[OSI Status].width", (Object)68);
        serializationContext.put("licensedata.column.[OSI Status].centered", (Object)true);
        serializationContext.put("licensedata.header.[Open CoDE Status].fg", (Object)"231,245,247");
        serializationContext.put("licensedata.header.[Open CoDE Status].orientation", (Object)"up");
        serializationContext.put("licensedata.header.[Open CoDE Status].width", (Object)68);
        serializationContext.put("licensedata.column.[Open CoDE Status].centered", (Object)true);
        serializationContext.put("licensedata.header.[Commercial].fg", (Object)"221,235,247");
        serializationContext.put("licensedata.header.[Commercial].orientation", (Object)"up");
        serializationContext.put("licensedata.column.[Commercial].centered", (Object)true);
        serializationContext.put("licensedata.header.[(Red Hat Only)].fg", (Object)"231,245,247");
        serializationContext.put("licensedata.header.[(Red Hat Only)].orientation", (Object)"up");
        serializationContext.put("licensedata.column.[(Red Hat Only)].centered", (Object)true);
        serializationContext.put("licensedata.header.[Type Artifact].fg", (Object)"219,219,219");
        serializationContext.put("licensedata.header.[Type Artifact].orientation", (Object)"up");
        serializationContext.put("licensedata.header.[Type Artifact].width", (Object)20);
        serializationContext.put("licensedata.column.[Type Artifact].centered", (Object)true);
        serializationContext.put("licensedata.header.[Type Package].fg", (Object)"219,219,219");
        serializationContext.put("licensedata.header.[Type Package].orientation", (Object)"up");
        serializationContext.put("licensedata.header.[Type Package].width", (Object)20);
        serializationContext.put("licensedata.column.[Type Package].centered", (Object)true);
        serializationContext.put("licensedata.header.[Type Web Module].fg", (Object)"219,219,219");
        serializationContext.put("licensedata.header.[Type Web Module].orientation", (Object)"up");
        serializationContext.put("licensedata.header.[Type Web Module].width", (Object)20);
        serializationContext.put("licensedata.column.[Type Web Module].centered", (Object)true);
        serializationContext.put("licensedata.header.[Unknown License Type].fg", (Object)"255,219,219");
        serializationContext.put("licensedata.header.[Unknown License Type].orientation", (Object)"up");
        serializationContext.put("licensedata.header.[Unknown License Type].width", (Object)20);
        serializationContext.put("licensedata.column.[Unknown License Type].centered", (Object)true);
        serializationContext.put("licensedata.header.[Assessment Pending].orientation", (Object)"up");
        serializationContext.put("licensedata.header.[Assessment Pending].width", (Object)20);
        serializationContext.put("licensedata.column.[Assessment Pending].centered", (Object)true);
        serializationContext.put("licensedata.header.[Open CoDE Assessment Pending].orientation", (Object)"up");
        serializationContext.put("licensedata.header.[Open CoDE Assessment Pending].width", (Object)20);
        serializationContext.put("licensedata.column.[Open CoDE Assessment Pending].centered", (Object)true);
        serializationContext.put("artifact.header.[Binary Artifact - Analysis Path].fg", (Object)"221,232,251");
        serializationContext.put("artifact.header.[Source Artifact - Analysis Path].fg", (Object)"251,232,207");
        serializationContext.put("artifact.header.[Source Archive - Analysis Path].fg", (Object)"251,242,207");
        serializationContext.put("artifact.header.[Descriptor - Analysis Path].fg", (Object)"187,226,229");
    }

    private void moveToEndColumn(List<String> artifactColumnList, String columnKey) {
        if (artifactColumnList.remove(columnKey)) {
            artifactColumnList.add(columnKey);
        }
    }

    private void moveToEndColumns(List<String> artifactColumnList, String prefix) {
        int endOfList = artifactColumnList.size();
        for (int j = 0; j < endOfList; ++j) {
            String column = artifactColumnList.get(j);
            if (!column.startsWith(prefix)) continue;
            artifactColumnList.remove(j);
            artifactColumnList.add(column);
            --j;
            --endOfList;
        }
    }

    protected void insertItem(List<String> attributeList, String referenceItem, String insertItem, int offset) {
        if (attributeList == null) {
            return;
        }
        int indexOfReferenceItem = attributeList.indexOf(referenceItem);
        int indexOfItem = attributeList.indexOf(insertItem);
        if (indexOfItem == -1) {
            return;
        }
        if (indexOfReferenceItem >= 0) {
            attributeList.remove(insertItem);
            attributeList.add(Math.min(Math.max(0, indexOfReferenceItem + offset), attributeList.size()), insertItem);
        }
    }

    public void removePartDetails(InventoryResource inventoryResource) {
        Inventory inventory = inventoryResource.getInventory();
        InventoryUtils.removeArtifactAttributeStartingWith((Inventory)inventory, (String)"Binary Artifact - ");
        InventoryUtils.removeArtifactAttributeStartingWith((Inventory)inventory, (String)"Source Artifact - ");
        InventoryUtils.removeArtifactAttributeStartingWith((Inventory)inventory, (String)"Source Archive - ");
        InventoryUtils.removeArtifactAttributeStartingWith((Inventory)inventory, (String)"Descriptor - ");
    }

    public void removeOnPortfolioLevel(InventoryResource inventoryResource) {
        Inventory inventory = inventoryResource.getInventory();
        InventoryUtils.removeArtifactAttribute((String)"InventoryClass", (Inventory)inventory);
        InventoryUtils.removeArtifactAttribute((String)"SpecificType", (Inventory)inventory);
        InventoryUtils.removeArtifactAttribute((String)"Structured", (Inventory)inventory);
        InventoryUtils.removeArtifactAttribute((String)"Path", (Inventory)inventory);
        InventoryUtils.removeArtifactAttribute((String)"Path in Asset", (Inventory)inventory);
        InventoryUtils.removeArtifactAttribute((String)"Hash (SHA-256)", (Inventory)inventory);
        InventoryUtils.removeArtifactAttribute((String)"Projects", (Inventory)inventory);
        InventoryUtils.removeArtifactAttribute((String)"Archive", (Inventory)inventory);
        InventoryUtils.removeArtifactAttribute((String)"Notice Parameter", (Inventory)inventory);
        InventoryUtils.removeArtifactAttribute((String)"Derived Notice Parameter", (Inventory)inventory);
        InventoryUtils.removeArtifactAttribute((String)"Classification", (Inventory)inventory);
        InventoryUtils.removeArtifactAttribute((String)"Packaging", (Inventory)inventory);
        InventoryUtils.removeArtifactAttribute((String)"Description", (Inventory)inventory);
        InventoryUtils.removeArtifactAttribute((String)"Summary", (Inventory)inventory);
    }

    public void formatPortfolioReport(InventoryResource inventoryResource) {
        Inventory inventory = inventoryResource.getInventory();
        InventorySerializationContext.initializeArtifactSerializationContext((Inventory)inventory);
        InventorySerializationContext serializationContext = inventory.getSerializationContext();
        List artifactColumnList = (List)serializationContext.get("artifact.columnlist");
        this.moveToEndColumn(artifactColumnList, "Checksum (MD5)");
        this.moveToEndColumn(artifactColumnList, "Content Checksum (MD5)");
        this.moveToEndColumn(artifactColumnList, "Hash (SHA-1)");
        this.moveToEndColumn(artifactColumnList, "Hash (SHA-256)");
        this.moveToEndColumn(artifactColumnList, "Hash (SHA-512)");
    }

    public void filter(InventoryResource inventoryResource, TaskType type) {
        switch (type) {
            case OVERALL_REPORT: 
            case PORTFOLIO_REPORT: {
                this.removePartDetails(inventoryResource);
                this.removeOnPortfolioLevel(inventoryResource);
            }
        }
    }
}

