/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow;

import com.metaeffekt.artifact.analysis.flow.ObserveFolderFlowParam;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.PropertyUtils;
import com.metaeffekt.flow.common.AbstractFlow;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObserveFolderFlow
extends AbstractFlow {
    private static final Logger LOG = LoggerFactory.getLogger(ObserveFolderFlow.class);
    private static final String KEY_STATUS = "status";
    private static final String KEY_CHECKSUM = "checksum";
    private static final String STATUS_NONE = "none";
    private static final String STATUS_COMPLETED = "completed";
    private static final String STATUS_INITIALIZED = "initialized";
    private static final String STATUS_PROCESSING = "processing";

    public void process(ObserveFolderFlowParam observeFolderFlowParam) {
        File observationDir = observeFolderFlowParam.getObservationDir();
        File statusBaseDir = observeFolderFlowParam.getStatusBaseDir();
        File tmpBaseDir = observeFolderFlowParam.getTmpBaseDir();
        int delayInSeconds = observeFolderFlowParam.getDelayInSeconds();
        this.validateObservationDir(observationDir);
        HashMap<File, String> fileToChecksumMap = new HashMap<File, String>();
        ExecutorService executor = Executors.newFixedThreadPool(observeFolderFlowParam.getNumThreads());
        while (true) {
            LOG.debug("Running observe scan folder input loop in [{}]", (Object)observationDir.getAbsolutePath());
            File[] files = observationDir.listFiles(pathname -> {
                if (pathname.getName().startsWith(".DS_Store")) {
                    return false;
                }
                return !pathname.isDirectory() || Objects.requireNonNull(pathname.listFiles(path -> !path.getName().startsWith(".DS_Store"))).length != 0;
            });
            if (files != null) {
                for (File file : files) {
                    LOG.debug("Running observe folder and manage triggers for file [{}].", (Object)file.getAbsolutePath());
                    this.observeFolderAndManageTriggerFile(file, fileToChecksumMap, statusBaseDir, tmpBaseDir);
                }
                for (File file : files) {
                    LOG.debug("Running observe trigger for file [{}].", (Object)file.getAbsolutePath());
                    this.observeTriggerFile(statusBaseDir, file, executor, observeFolderFlowParam.getConsumer());
                }
            }
            try {
                Thread.sleep(delayInSeconds * 1000);
            }
            catch (InterruptedException e) {
                this.awaitTermination(executor);
                return;
            }
        }
    }

    protected void awaitTermination(ExecutorService executor) {
        executor.shutdown();
        while (!executor.isTerminated()) {
            try {
                executor.awaitTermination(200L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void observeTriggerFile(File statusBaseDir, File file, ExecutorService executor, Consumer<File> consumer) {
        Properties triggerProperties;
        String status;
        File triggerPropertiesFile = new File(statusBaseDir, file.getName() + ".trigger.properties");
        if (triggerPropertiesFile.exists() && (status = (triggerProperties = PropertyUtils.loadProperties((File)triggerPropertiesFile)).getProperty(KEY_STATUS, STATUS_NONE)).equals(STATUS_INITIALIZED)) {
            LOG.warn("Triggering process execution for [{}].", (Object)file);
            triggerProperties.setProperty(KEY_STATUS, STATUS_PROCESSING);
            PropertyUtils.saveProperties((File)triggerPropertiesFile, (Properties)triggerProperties);
            executor.submit(() -> {
                LOG.info("Processing [{}]...", (Object)file);
                consumer.accept(file);
                Properties p = PropertyUtils.loadProperties((File)triggerPropertiesFile);
                p.setProperty(KEY_STATUS, STATUS_COMPLETED);
                PropertyUtils.saveProperties((File)triggerPropertiesFile, (Properties)p);
                LOG.info("Processing [{}] completed.", (Object)file);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void observeFolderAndManageTriggerFile(File file, Map<File, String> fileToChecksumMap, File statusBaseDir, File tmpBaseDir) {
        try {
            String previousChecksum;
            String md5Checksum;
            if (file.isDirectory()) {
                File contentChecksumFile = new File(tmpBaseDir, file.getName() + ".content.md5");
                try {
                    FileUtils.createDirectoryContentChecksumFile((File)file, (File)contentChecksumFile);
                    md5Checksum = FileUtils.computeChecksum((File)contentChecksumFile);
                }
                finally {
                    FileUtils.forceDelete((File)contentChecksumFile);
                }
            } else {
                md5Checksum = FileUtils.computeChecksum((File)file);
            }
            if ((previousChecksum = fileToChecksumMap.get(file)) == null) {
                LOG.debug("Observing [{}] the first time.", (Object)file.getAbsolutePath());
                fileToChecksumMap.put(file, md5Checksum);
            } else if (previousChecksum.equals(md5Checksum)) {
                String triggerStatus;
                LOG.debug("Observing process status for [{}].", (Object)file.getAbsolutePath());
                File triggerPropertiesFile = new File(statusBaseDir, file.getName() + ".trigger.properties");
                Properties triggerProperties = triggerPropertiesFile.exists() ? PropertyUtils.loadProperties((File)triggerPropertiesFile) : new Properties();
                String triggerChecksum = triggerProperties.getProperty(KEY_CHECKSUM, "");
                switch (triggerStatus = triggerProperties.getProperty(KEY_STATUS, STATUS_NONE)) {
                    case "none": {
                        this.initializeTrigger(file, md5Checksum, triggerPropertiesFile);
                        break;
                    }
                    case "completed": 
                    case "initialized": {
                        if (triggerChecksum.equals(md5Checksum)) break;
                        this.initializeTrigger(file, md5Checksum, triggerPropertiesFile);
                        break;
                    }
                    default: {
                        LOG.info("Skipping process trigger for [{}]. Status is [{}].", (Object)file.getAbsolutePath(), (Object)triggerStatus);
                    }
                }
            } else {
                fileToChecksumMap.put(file, md5Checksum);
                LOG.info("Observed changes in [{}].", (Object)file.getAbsolutePath());
            }
        }
        catch (IOException e) {
            LOG.warn("Exception [{}] while observing folder [{}]", (Object)e.getMessage(), (Object)file.getAbsolutePath());
        }
    }

    private void initializeTrigger(File file, String md5Checksum, File triggerPropertiesFile) {
        LOG.info("Initializing process trigger for [{}].", (Object)file.getAbsolutePath());
        Properties triggerProperties = new Properties();
        triggerProperties.setProperty(KEY_CHECKSUM, md5Checksum);
        triggerProperties.setProperty(KEY_STATUS, STATUS_INITIALIZED);
        PropertyUtils.saveProperties((File)triggerPropertiesFile, (Properties)triggerProperties);
    }

    private void validateObservationDir(File observationDir) {
        if (!observationDir.exists()) {
            throw new IllegalStateException(String.format("Observation directory [%s] must exist.", observationDir.getAbsolutePath()));
        }
        if (!observationDir.isDirectory()) {
            throw new IllegalStateException(String.format("Observation directory [%s] not a directory.", observationDir.getAbsolutePath()));
        }
    }
}

