/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow;

import com.metaeffekt.artifact.analysis.bom.cyclonedx.CycloneDxImporter;
import com.metaeffekt.artifact.analysis.bom.parameters.ImportParameters;
import com.metaeffekt.artifact.analysis.flow.ObservePortfolioFlowParam;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.FileLocation;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.ProcessInventoryParams;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.PushResponse;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.ReportInventoryParams;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.Task;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.TaskType;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.workbench.TaskUtils;
import com.metaeffekt.artifact.analysis.workbench.WorkbenchTaskQueue;
import com.metaeffekt.artifact.analysis.workbench.executors.OverallReportTaskExecutor;
import com.metaeffekt.flow.common.AbstractFlow;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.reader.InventoryReader;
import org.metaeffekt.core.inventory.processor.writer.InventoryWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservePortfolioFlow
extends AbstractFlow {
    private static final Logger log = LoggerFactory.getLogger(ObservePortfolioFlow.class);
    public static final int THREE_DAYS_MILLIS = 259200000;

    public void loop(ObservePortfolioFlowParam observePortfolioFlowParam) {
        File portfolioBaseDir = observePortfolioFlowParam.getPortfolioBaseDir();
        while (true) {
            log.debug("Running observe portfolio loop in [{}]...", (Object)portfolioBaseDir.getAbsolutePath());
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.observeIncomingInventories(observePortfolioFlowParam);
            }
            catch (Exception e) {
                log.warn("Exception while running portfolio loop; observing updates", (Throwable)e);
            }
            try {
                this.updateReports(observePortfolioFlowParam, portfolioBaseDir);
            }
            catch (Exception e) {
                log.warn("Exception while running portfolio loop; updating reports.", (Throwable)e);
            }
            log.debug("Running observe portfolio loop in [{}] completed.", (Object)portfolioBaseDir.getAbsolutePath());
            try {
                Thread.sleep(18000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void observeIncomingInventories(ObservePortfolioFlowParam observePortfolioFlowParam) {
        List<Pair<File, File>> initialValidatedFilePairs = this.detectFilesToProcess(observePortfolioFlowParam);
        List<File> filesToProcess = this.convertAndValidate(initialValidatedFilePairs);
        this.pushTasks(observePortfolioFlowParam, filesToProcess);
    }

    private void pushTasks(ObservePortfolioFlowParam observePortfolioFlowParam, List<File> filesToProcess) {
        for (File validatedInventoryFile : filesToProcess) {
            try {
                this.pushTaskToScanWorker(observePortfolioFlowParam, validatedInventoryFile);
            }
            catch (Exception e) {
                log.error("Cannot further process [{}].", (Object)validatedInventoryFile.getAbsolutePath(), (Object)e);
                FileUtils.deleteQuietly((File)validatedInventoryFile);
            }
        }
    }

    private void pushTaskToScanWorker(ObservePortfolioFlowParam observePortfolioFlowParam, File validatedInventoryFile) throws IOException {
        ProcessInventoryParams.Builder inventoryParams = ProcessInventoryParams.newBuilder().setFile(TaskUtils.createFile(observePortfolioFlowParam.getPortfolioBaseDir(), validatedInventoryFile)).setTarget(TaskUtils.createFileLocation(observePortfolioFlowParam.getPortfolioBaseDir(), validatedInventoryFile));
        Task task = Task.newBuilder().setType(TaskType.PROCESS).setId(UUID.randomUUID().toString()).setCreated(TaskUtils.createIsoTimestamp()).setProcessInventory(inventoryParams).build();
        log.info("Pushing [{}] task [{}] to scan worker...", (Object)task.getType(), (Object)task.getId());
        PushResponse pushResponse = observePortfolioFlowParam.getWorkerClient().push(task);
        if (pushResponse.getCode() != 0) {
            log.warn("Remote worker responded with error [{}] pushing task [{}]. Message: {}.", new Object[]{pushResponse.getCode(), task.getId(), pushResponse.getMessage()});
        } else {
            log.info("Pushing [{}] task [{}] to scan worker completed.", (Object)task.getType(), (Object)task.getId());
        }
    }

    private List<File> convertAndValidate(List<Pair<File, File>> initialValidatedFilePairs) {
        ArrayList<File> filesToProcess = new ArrayList<File>();
        for (Pair<File, File> initialValidatedPair : initialValidatedFilePairs) {
            File initialInputFile = (File)initialValidatedPair.getKey();
            File validatedInventoryFile = (File)initialValidatedPair.getValue();
            String extension = FilenameUtils.getExtension((String)initialInputFile.getName()).toLowerCase(Locale.US);
            Inventory inventory = null;
            switch (extension) {
                case "xls": 
                case "xlsx": 
                case "ser": {
                    try {
                        inventory = new InventoryReader().readInventory(initialInputFile);
                    }
                    catch (Exception e) {
                        log.warn("Cannot validate file [{}].", (Object)initialInputFile.getAbsolutePath());
                    }
                    break;
                }
                case "json": 
                case "xml": {
                    try {
                        CycloneDxImporter importer = new CycloneDxImporter(ImportParameters.builder().build());
                        inventory = importer.importFromFile(initialInputFile);
                    }
                    catch (Exception e) {
                        log.warn("Cannot validate file [{}].", (Object)initialInputFile.getAbsolutePath());
                    }
                    break;
                }
                default: {
                    log.warn("Cannot validate file [{}]. No matching importer for extension [{}].", (Object)initialInputFile.getAbsolutePath(), (Object)extension);
                }
            }
            if (inventory == null) continue;
            try {
                new InventoryWriter().writeInventory(inventory, validatedInventoryFile);
                filesToProcess.add(validatedInventoryFile);
            }
            catch (IOException e) {
                log.warn("Cannot write validated inventory file [{}].", (Object)validatedInventoryFile.getAbsolutePath());
            }
        }
        return filesToProcess;
    }

    private List<Pair<File, File>> detectFilesToProcess(ObservePortfolioFlowParam observePortfolioFlowParam) {
        File portfolioBaseDir = observePortfolioFlowParam.getPortfolioBaseDir();
        log.debug("Detecting portfolio updates in [{}]...", (Object)portfolioBaseDir.getAbsolutePath());
        String[] detectedFiles = FileUtils.scanDirectoryForFiles((File)portfolioBaseDir, (String[])new String[]{"**/*_initial.json", "**/*_initial.xls", "**/*_initial.xlsx"});
        ArrayList<Pair<File, File>> initialValidatedFilePairs = new ArrayList<Pair<File, File>>();
        log.debug("Processing [{}] detected files...", (Object)detectedFiles.length);
        for (String filename : detectedFiles) {
            File detectedFile = new File(portfolioBaseDir, filename);
            String validatedFileName = detectedFile.getName();
            int suffixIndex = validatedFileName.lastIndexOf("_initial.");
            validatedFileName = validatedFileName.substring(0, suffixIndex);
            validatedFileName = validatedFileName + "_validated.xlsx";
            File validatedFile = new File(detectedFile.getParent(), validatedFileName);
            if (validatedFile.exists()) {
                long tsInitial = detectedFile.lastModified();
                long tsValidated = validatedFile.lastModified();
                long now = System.currentTimeMillis();
                if (tsValidated > tsInitial && tsValidated >= now - 259200000L) continue;
                initialValidatedFilePairs.add((Pair<File, File>)Pair.of((Object)detectedFile, (Object)validatedFile));
                continue;
            }
            initialValidatedFilePairs.add((Pair<File, File>)Pair.of((Object)detectedFile, (Object)validatedFile));
        }
        log.debug("Detecting portfolio updates in [{}] completed.", (Object)portfolioBaseDir.getAbsolutePath());
        return initialValidatedFilePairs;
    }

    private void updateReports(ObservePortfolioFlowParam observePortfolioFlowParam, File portfolioBaseDir) {
        File assetGroupDir;
        List<File> allCollectedInventories = OverallReportTaskExecutor.scanForValidatedOrReportedInventories(portfolioBaseDir);
        WorkbenchTaskQueue workbenchTaskQueue = observePortfolioFlowParam.getWorkbenchTaskQueue();
        log.debug("Detecting required report updates in [{}]...", (Object)portfolioBaseDir.getAbsolutePath());
        int scheduledReportCount = 0;
        String portfolioReportProjectName = observePortfolioFlowParam.getPropertyProvider().getProperty("workbench.portfolio.report.project.name", null);
        String portfolioReportProjectId = observePortfolioFlowParam.getPropertyProvider().getProperty("workbench.portfolio.report.project.id", null);
        if (portfolioReportProjectId == null || portfolioReportProjectName == null) {
            return;
        }
        String string = portfolioReportProjectId + "/" + portfolioReportProjectName + "/Reports/SNAPSHOT/" + portfolioReportProjectName + "-Portfolio_report.xlsx";
        File portfolioReport = new File(portfolioBaseDir, string);
        boolean schedulePortfolioReport = false;
        if (portfolioReport.exists()) {
            List<File> updatedInventories = OverallReportTaskExecutor.filterByTimestamp(allCollectedInventories, portfolioReport.lastModified());
            if (!updatedInventories.isEmpty()) {
                schedulePortfolioReport = true;
            }
        } else {
            schedulePortfolioReport = true;
        }
        if (schedulePortfolioReport) {
            this.scheduleReport(workbenchTaskQueue, portfolioBaseDir, portfolioBaseDir, string, TaskType.PORTFOLIO_REPORT);
            ++scheduledReportCount;
        }
        HashMap<File, List> assertGroupFileMap = new HashMap<File, List>();
        for (File file : allCollectedInventories) {
            assetGroupDir = file.getParentFile().getParentFile();
            assertGroupFileMap.computeIfAbsent(assetGroupDir, a -> new ArrayList()).add(file);
        }
        for (Map.Entry entry : assertGroupFileMap.entrySet()) {
            assetGroupDir = (File)entry.getKey();
            File projectDir = assetGroupDir.getParentFile();
            File projectReport = new File(projectDir, "Reports/SNAPSHOT/" + projectDir.getName() + "_report.xlsx");
            String reportRelativePath = FileUtils.asRelativePath((File)portfolioBaseDir, (File)projectReport);
            boolean scheduleReport = false;
            if (projectReport.exists()) {
                List<File> updatedInventories = OverallReportTaskExecutor.filterByTimestamp((List)entry.getValue(), projectReport.lastModified());
                if (!updatedInventories.isEmpty()) {
                    scheduleReport = true;
                }
            } else {
                scheduleReport = true;
            }
            if (!scheduleReport) continue;
            this.scheduleReport(workbenchTaskQueue, portfolioBaseDir, assetGroupDir, reportRelativePath, TaskType.PROJECT_REPORT);
            ++scheduledReportCount;
        }
        assertGroupFileMap = new HashMap();
        for (File file : allCollectedInventories) {
            assetGroupDir = file.getParentFile();
            assertGroupFileMap.computeIfAbsent(assetGroupDir, a -> new ArrayList()).add(file);
        }
        for (Map.Entry entry : assertGroupFileMap.entrySet()) {
            File assetGroupVersionSpecificDir = (File)entry.getKey();
            File assetGroupDir2 = assetGroupVersionSpecificDir.getParentFile();
            File projectDir = assetGroupDir2.getParentFile();
            File assetGroupReport = new File(projectDir, "Reports/SNAPSHOT/" + assetGroupDir2.getName() + "-" + assetGroupVersionSpecificDir.getName() + "_report.xlsx");
            String reportRelativePath = FileUtils.asRelativePath((File)portfolioBaseDir, (File)assetGroupReport);
            boolean scheduleReport = false;
            if (assetGroupReport.exists()) {
                List<File> updatedInventories = OverallReportTaskExecutor.filterByTimestamp((List)entry.getValue(), assetGroupReport.lastModified());
                if (!updatedInventories.isEmpty()) {
                    scheduleReport = true;
                }
            } else {
                scheduleReport = true;
            }
            if (!scheduleReport) continue;
            this.scheduleReport(workbenchTaskQueue, portfolioBaseDir, assetGroupVersionSpecificDir, reportRelativePath, TaskType.ASSET_GROUP_REPORT);
            ++scheduledReportCount;
        }
        log.debug("Detecting required report updates in [{}] completed. [{}] reports scheduled.", (Object)portfolioBaseDir.getAbsolutePath(), (Object)scheduledReportCount);
    }

    private void scheduleReport(WorkbenchTaskQueue workbenchTaskQueue, File portfolioBaseDir, File reportBaseDir, String portfolioReportRelativePath, TaskType type) {
        FileLocation.Builder outFileLocation = FileLocation.newBuilder().setBaseDir(portfolioBaseDir.getAbsolutePath()).setRelativePath(portfolioReportRelativePath);
        ReportInventoryParams.Builder reportInventoryParams = ReportInventoryParams.newBuilder().setInBaseDir(reportBaseDir.getAbsolutePath()).setOutFile(outFileLocation);
        Task portfolioReportTask = Task.newBuilder().setType(type).setId(UUID.randomUUID().toString()).setCreated(TaskUtils.createIsoTimestamp()).setReportInventory(reportInventoryParams).build();
        try {
            workbenchTaskQueue.schedule(portfolioReportTask);
        }
        catch (IOException e) {
            log.error("Cannot schedule portfolio report task.", (Throwable)e);
        }
    }
}

