/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow;

import com.metaeffekt.artifact.analysis.flow.InventoryResult;
import com.metaeffekt.artifact.analysis.flow.ResolverFlowParam;
import com.metaeffekt.resource.InventoryResource;
import java.io.File;
import org.metaeffekt.artifact.resolver.ArtifactResolverConfig;
import org.metaeffekt.artifact.resolver.ArtifactResolverManager;
import org.metaeffekt.artifact.resolver.download.ProxyConfig;
import org.metaeffekt.artifact.resolver.download.WebAccess;
import org.metaeffekt.artifact.resolver.model.DownloadLocation;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;

public class ResolverFlow {
    public static final String RESOLVER_DIRECTIVE = "Resolver Directive";
    public static final String RESOLVER_DIRECTIVE_SKIP = "skip";

    public InventoryResult process(ResolverFlowParam resolverFlowParam) {
        ArtifactResolverManager artifactResolverManager = this.instantiateArtifactResolver(resolverFlowParam);
        InventoryResource inventoryResource = resolverFlowParam.getInventoryResource();
        Inventory inventory = inventoryResource.getInventory();
        for (Artifact artifact : inventory.getArtifacts()) {
            String resolverDirective = artifact.get(RESOLVER_DIRECTIVE);
            if (RESOLVER_DIRECTIVE_SKIP.equalsIgnoreCase(resolverDirective)) continue;
            try {
                artifactResolverManager.resolveAndMergeAll(artifact);
            }
            catch (Exception e) {
                artifact.append("Errors", String.format("Unable to resolve artifact [%s]", artifact.createStringRepresentation()), "\n");
            }
        }
        return new InventoryResult(inventoryResource);
    }

    private ArtifactResolverManager instantiateArtifactResolver(ResolverFlowParam resolverFlowParam) {
        File downloadBaseDir = new File(resolverFlowParam.getPropertyProvider().getRequiredProperty("artifact.resolver.download.dir"));
        File proxyConfigYaml = new File(resolverFlowParam.getPropertyProvider().getRequiredProperty("artifact.resolver.proxy.config"));
        File artifactResolverConfigYaml = new File(resolverFlowParam.getPropertyProvider().getRequiredProperty("artifact.resolver.config"));
        try {
            DownloadLocation downloadLocation = new DownloadLocation(downloadBaseDir);
            WebAccess webAccess = new WebAccess(ProxyConfig.parseFromYaml((File)proxyConfigYaml));
            ArtifactResolverConfig artifactResolverConfig = ArtifactResolverConfig.parseFromYaml((File)artifactResolverConfigYaml);
            return new ArtifactResolverManager(downloadLocation, webAccess, artifactResolverConfig);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create Artifact Resolver.", e);
        }
    }
}

