/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow;

import com.metaeffekt.artifact.analysis.flow.AttachReportFlow;
import com.metaeffekt.artifact.analysis.flow.FormatInventoryFlow;
import com.metaeffekt.artifact.analysis.flow.ResolverFlow;
import com.metaeffekt.artifact.analysis.flow.ResolverFlowParam;
import com.metaeffekt.artifact.analysis.flow.ScanFlow;
import com.metaeffekt.artifact.analysis.flow.ScanFlowParam;
import com.metaeffekt.artifact.analysis.flow.ScanFlowResult;
import com.metaeffekt.artifact.analysis.flow.SpdxDocumentFlow;
import com.metaeffekt.artifact.analysis.model.PropertyProvider;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.InventoryUtils;
import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import com.metaeffekt.artifact.analysis.workbench.ProjectInventoryFilter;
import com.metaeffekt.artifact.extractors.configuration.DirectoryScanExtractorConfiguration;
import com.metaeffekt.artifact.extractors.configuration.ExtractorConfiguration;
import com.metaeffekt.artifact.extractors.flow.ExtractorFlow;
import com.metaeffekt.artifact.extractors.flow.ExtractorParam;
import com.metaeffekt.artifact.extractors.flow.ExtractorResult;
import com.metaeffekt.artifact.terms.model.LicenseTextProvider;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.resource.InventoryResource;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.AssetMetaData;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.LicenseData;
import org.metaeffekt.core.inventory.processor.report.DirectoryInventoryScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanConsumer
implements Consumer<File> {
    private static final Logger LOG = LoggerFactory.getLogger(ScanConsumer.class);
    private final File analysisBaseDir;
    private final File tmpBaseDir;
    private final File resultTargetDir;
    private final InventoryResource referenceInventoryResource;
    private final ScanFlowParam scanFlowParamTemplate;

    public ScanConsumer(File analysisBaseDir, File tmpBaseDir, File resultTargetDir, InventoryResource referenceInventoryResource, ScanFlowParam scanFlowParamTemplate) {
        this.analysisBaseDir = analysisBaseDir;
        this.tmpBaseDir = tmpBaseDir;
        this.resultTargetDir = resultTargetDir;
        this.referenceInventoryResource = referenceInventoryResource;
        this.scanFlowParamTemplate = scanFlowParamTemplate;
    }

    @Override
    public void accept(File file) {
        String humanReadableTimestamp = TimeUtils.createHumanReadableTimestamp();
        File intermediateOutputDir = new File(this.tmpBaseDir, file.getName() + "-" + humanReadableTimestamp);
        File targetOutputDir = new File(this.resultTargetDir, file.getName() + "-" + humanReadableTimestamp);
        File intermediateScanDir = new File(this.tmpBaseDir, "scan-" + file.getName());
        try {
            this.manageInputAndScanDirForFile(file, intermediateOutputDir, intermediateScanDir);
            PropertyProvider propertyProvider = this.scanFlowParamTemplate.getPropertyProvider();
            String[] licenseScanIncludes = propertyProvider.getProperty("analyze.scan.license.includes", "**/*").split(",");
            String[] licenseScanExcludes = propertyProvider.getProperty("analyze.scan.license.excludes", "**/.DS_Store*").split(",");
            Inventory referenceInventory = this.referenceInventoryResource.reloadInventory();
            DirectoryInventoryScan scan = new DirectoryInventoryScan(intermediateScanDir, intermediateScanDir, licenseScanIncludes, licenseScanExcludes, referenceInventory);
            scan.setEnableImplicitUnpack(true);
            scan.setIncludeEmbedded(true);
            scan.setEnableDetectComponentPatterns(true);
            Inventory inventory = scan.performScan();
            InventoryResource inventoryResource = InventoryResource.fromInventory((Inventory)inventory);
            File analysedInventoryFile = new File(intermediateOutputDir, "license-scanner-inventory-" + humanReadableTimestamp + "_01-analyse.xlsx");
            File curatedInventoryFile = new File(intermediateOutputDir, "license-scanner-inventory-" + humanReadableTimestamp + "_02-curate.xlsx");
            File resolvedInventoryFile = new File(intermediateOutputDir, "license-scanner-inventory-" + humanReadableTimestamp + "_03-resolve.xlsx");
            File scannedInventoryFile = new File(intermediateOutputDir, "license-scanner-inventory-" + humanReadableTimestamp + "_04-scanned.xlsx");
            File resultInventoryFile = new File(targetOutputDir, "license-scanner-inventory-" + humanReadableTimestamp + ".xlsx");
            inventoryResource.sync(analysedInventoryFile);
            DirectoryScanExtractorConfiguration configuration = new DirectoryScanExtractorConfiguration(file.getName(), referenceInventory, analysedInventoryFile, intermediateScanDir);
            ExtractorParam extractorParam = new ExtractorParam().using((ExtractorConfiguration)configuration).extractArchivesTo(new File(intermediateOutputDir, file.getName()));
            LOG.info("Running ExtractorFlow on [{}]...", (Object)intermediateScanDir.getAbsolutePath());
            ExtractorFlow extractorFlow = new ExtractorFlow();
            ExtractorResult extractorResult = extractorFlow.extract(extractorParam);
            inventoryResource = InventoryResource.fromInventory((Inventory)extractorResult.getAggregatedInventory());
            inventoryResource.sync(analysedInventoryFile);
            Object projectInventoryFilter = new ProjectInventoryFilter();
            ((ProjectInventoryFilter)projectInventoryFilter).setEnableApplyCurationData(true);
            ((ProjectInventoryFilter)projectInventoryFilter).process(inventoryResource.getInventory(), referenceInventory);
            inventoryResource.sync(curatedInventoryFile);
            LOG.info("ExtractorFlow completed.");
            LOG.info("Running ResolverFlow on [{}]...", (Object)curatedInventoryFile.getAbsolutePath());
            ResolverFlow resolverFlow = new ResolverFlow();
            ResolverFlowParam resolverFlowParam = new ResolverFlowParam();
            resolverFlowParam.withInventory(inventoryResource);
            resolverFlowParam.configuredBy(this.scanFlowParamTemplate.getPropertyProvider());
            resolverFlow.process(resolverFlowParam);
            inventoryResource.sync(resolvedInventoryFile);
            LOG.info("Running ResolverFlow on [{}] completed.", (Object)curatedInventoryFile.getAbsolutePath());
            LOG.info("Running ScanFlow on [{}]...", (Object)resolvedInventoryFile.getAbsolutePath());
            ScanFlowParam scanFlowParam = ScanFlowParam.copy(this.scanFlowParamTemplate);
            scanFlowParam.withInventory(inventoryResource);
            ScanFlowResult scanFlowResult = new ScanFlow().process(scanFlowParam);
            LOG.info("Running ScanFlow on [{}] completed.", (Object)resolvedInventoryFile.getAbsolutePath());
            this.concludeAssetMetaData(file, scanFlowResult);
            LOG.info("Aggregating analysis results on [{}]...", (Object)resolvedInventoryFile.getAbsolutePath());
            for (Artifact artifact : scanFlowResult.getInventory().getArtifacts()) {
                this.aggregateAnalysisResult(targetOutputDir, artifact, artifact.get("Analysis Path"), "");
                this.aggregateAnalysisResult(targetOutputDir, artifact, artifact.get("Binary Artifact - Analysis Path"), "Binary Artifact - ");
                this.aggregateAnalysisResult(targetOutputDir, artifact, artifact.get("Source Artifact - Analysis Path"), "Source Artifact - ");
                this.aggregateAnalysisResult(targetOutputDir, artifact, artifact.get("Source Archive - Analysis Path"), "Source Archive - ");
                this.aggregateAnalysisResult(targetOutputDir, artifact, artifact.get("Descriptor - Analysis Path"), "Descriptor - ");
            }
            LOG.info("Aggregating analysis results on [{}] completed.", (Object)resolvedInventoryFile.getAbsolutePath());
            LOG.info("Applying project inventory filtering [{}]...", (Object)resolvedInventoryFile.getAbsolutePath());
            projectInventoryFilter = new ProjectInventoryFilter();
            ((ProjectInventoryFilter)projectInventoryFilter).setEnableInherit(false);
            ((ProjectInventoryFilter)projectInventoryFilter).setEnableUseDerivedLicense(false);
            ((ProjectInventoryFilter)projectInventoryFilter).setEnableAddComponentNameAndVersion(false);
            ((ProjectInventoryFilter)projectInventoryFilter).setEnableApplyCurationData(true);
            ((ProjectInventoryFilter)projectInventoryFilter).process(inventoryResource.getInventory(), referenceInventory);
            LOG.info("Applying project inventory filtering [{}] completed.", (Object)resolvedInventoryFile.getAbsolutePath());
            LOG.info("Transferring business case data for [{}]...", (Object)resolvedInventoryFile.getAbsolutePath());
            ScanConsumer.transferBusinessCaseAssessmentData(referenceInventory, scanFlowResult.getInventory());
            LOG.info("Transferring business case data for [{}] completed.", (Object)resolvedInventoryFile.getAbsolutePath());
            LOG.info("Writing inventory [{}]...", (Object)scannedInventoryFile.getAbsolutePath());
            FileUtils.forceMkDirQuietly((File)scannedInventoryFile.getParentFile());
            inventoryResource.sync(scannedInventoryFile);
            LOG.info("Writing inventory [{}] completed.", (Object)scannedInventoryFile.getAbsolutePath());
            LOG.info("Attaching report flow [{}]...", (Object)scannedInventoryFile.getAbsolutePath());
            new AttachReportFlow().attachReport(inventoryResource);
            new FormatInventoryFlow().filterAndFormat(inventoryResource);
            inventoryResource.sync(resultInventoryFile);
            LOG.info("Attaching report flow [{}] completed.", (Object)scannedInventoryFile.getAbsolutePath());
            File targetSpdxDocumentFile = new File(targetOutputDir, "license-scanner-spdx-" + humanReadableTimestamp + ".json");
            LOG.info("Producing SPDX [{}]...", (Object)targetSpdxDocumentFile.getAbsolutePath());
            NormalizationMetaData normalizationMetaData = scanFlowParam.getNormalizationMetaData();
            LicenseTextProvider licenseTextProvider = scanFlowParam.getLicenseTextProvider();
            SpdxDocumentFlow.produceSpdxDocument(inventoryResource, file.getName(), targetSpdxDocumentFile, normalizationMetaData, licenseTextProvider, propertyProvider);
            LOG.info("Producing SPDX [{}] completed.", (Object)targetSpdxDocumentFile.getAbsolutePath());
        }
        catch (Exception e) {
            LOG.error("Error processing scan for [{}]. [Thread {}]", new Object[]{file, Thread.currentThread().getId(), e});
        }
        catch (Error error) {
            LOG.error("Error processing scan for [{}]. [Thread {}]", new Object[]{file, Thread.currentThread().getId(), error});
        }
    }

    private void aggregateAnalysisResult(File targetOutputDir, Artifact artifact, String analysisPath, String context) throws IOException {
        if (analysisPath != null) {
            File analysisResults = new File(analysisPath + "-analysis");
            String intermediateFolder = FileUtils.asRelativePath((File)this.analysisBaseDir.getCanonicalFile(), (File)analysisResults.getCanonicalFile());
            File targetFile = new File(targetOutputDir, intermediateFolder);
            if (analysisResults.exists()) {
                FileUtils.copyDirectory((File)analysisResults, (File)targetFile, f -> {
                    if (f.isDirectory()) {
                        return false;
                    }
                    return !f.getName().endsWith("_license-scan-segments.txt");
                });
                artifact.set(context + "Result Path", targetFile.getAbsolutePath());
            }
        }
    }

    private void concludeAssetMetaData(File originalFile, ScanFlowResult scanFlowResult) {
        Inventory inventory = scanFlowResult.getInventory();
        HashSet<String> coveredAssetIds = new HashSet<String>();
        Set assetIdList = InventoryUtils.collectAssetIdsFromArtifacts((Inventory)inventory);
        for (String assetId : assetIdList) {
            Artifact artifact;
            int dashIndexLast;
            int dashIndexFirst = assetId.indexOf("-");
            if (dashIndexFirst >= (dashIndexLast = assetId.lastIndexOf("-"))) continue;
            String artifactId = assetId.substring(dashIndexFirst + 1, dashIndexLast);
            String checksum = assetId.substring(dashIndexLast + 1);
            if (checksum.length() < 32 || (artifact = inventory.findArtifactByIdAndChecksum(artifactId, checksum)) == null) continue;
            this.createAssetMetaDataFromArtifact(inventory, artifact, assetId);
            coveredAssetIds.add(assetId);
        }
        for (Artifact artifact : inventory.getArtifacts()) {
            Set artifactAssetIds;
            String artifactAssetId = InventoryUtils.deriveAssetIdFromArtifact((Artifact)artifact);
            if (artifactAssetId == null || coveredAssetIds.contains(artifactAssetId) || !(artifactAssetIds = InventoryUtils.collectAssetIdsFromArtifact((Artifact)artifact)).isEmpty()) continue;
            this.createAssetMetaDataFromArtifact(inventory, artifact, artifactAssetId);
            coveredAssetIds.add(artifactAssetId);
        }
    }

    private void createAssetMetaDataFromArtifact(Inventory inventory, Artifact artifact, String assetId) {
        AssetMetaData assetMetaData = new AssetMetaData();
        assetMetaData.set(AssetMetaData.Attribute.ASSET_ID, assetId);
        assetMetaData.set("Type", "Artifact");
        assetMetaData.set("Artifact Id", artifact.getId());
        assetMetaData.set("Name", artifact.getId());
        assetMetaData.set((AbstractModelBase.Attribute)Artifact.Attribute.VERSION, artifact.getVersion());
        assetMetaData.set("Tag", artifact.get("Tag"));
        assetMetaData.set("Checksum (MD5)", artifact.getChecksum());
        assetMetaData.set("Hash (SHA-256)", artifact.get("Hash (SHA-256)"));
        assetMetaData.set("Hash (SHA-1)", artifact.get("Hash (SHA-1)"));
        assetMetaData.set("Path in Asset", artifact.get("Path in Asset"));
        inventory.getAssetMetaData().add(assetMetaData);
    }

    private void manageInputAndScanDirForFile(File file, File intermediateOutputDir, File intermediateScanDir) throws IOException {
        if (intermediateScanDir.exists()) {
            FileUtils.deleteDirectory((File)intermediateScanDir);
        }
        FileUtils.forceMkDirQuietly((File)intermediateScanDir);
        FileUtils.forceMkDirQuietly((File)intermediateOutputDir);
        if (file.isDirectory()) {
            FileUtils.copyDirectory((File)file, (File)intermediateScanDir);
        } else {
            FileUtils.copyFile((File)file, (File)new File(intermediateScanDir, file.getName()));
        }
    }

    @Override
    public Consumer<File> andThen(Consumer<? super File> after) {
        return Consumer.super.andThen(after);
    }

    public static void transferBusinessCaseAssessmentData(Inventory referenceInventory, Inventory inventory) throws IOException {
        String licenseId;
        HashMap<String, LicenseData> licenseDataMap = new HashMap<String, LicenseData>();
        HashSet attributeKeys = new HashSet();
        for (LicenseData licenseData : inventory.getLicenseData()) {
            licenseId = licenseData.get(LicenseData.Attribute.CANONICAL_NAME);
            licenseDataMap.put(licenseId, licenseData);
            attributeKeys.addAll(licenseData.getAttributes());
        }
        for (LicenseData customerLicenseData : referenceInventory.getLicenseData()) {
            licenseId = customerLicenseData.get(LicenseData.Attribute.CANONICAL_NAME);
            LicenseData licenseData = (LicenseData)licenseDataMap.get(licenseId);
            if (licenseData != null) {
                for (String key : customerLicenseData.getAttributes()) {
                    if (attributeKeys.contains(key)) continue;
                    licenseData.set(key, customerLicenseData.get(key));
                }
            }
            licenseDataMap.remove(licenseId);
        }
    }
}

