/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow;

import com.metaeffekt.artifact.analysis.flow.ConfiguredFlowParam;
import com.metaeffekt.artifact.terms.model.LicenseTextProvider;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.resource.InventoryResource;
import java.io.File;
import org.metaeffekt.core.inventory.processor.model.Inventory;

public class ScanFlowParam
extends ConfiguredFlowParam<ScanFlowParam> {
    private NormalizationMetaData normalizationMetaData;
    private LicenseTextProvider licenseTextProvider;
    private File analysisBaseDir;
    private InventoryResource inventoryResource;
    private File resultTargetDir;

    private ScanFlowParam() {
    }

    public static ScanFlowParam copy(ScanFlowParam scanFlowParam) {
        ScanFlowParam sfp = new ScanFlowParam();
        sfp.withInventory(scanFlowParam.inventoryResource);
        sfp.using(scanFlowParam.analysisBaseDir);
        sfp.using(scanFlowParam.normalizationMetaData);
        sfp.using(scanFlowParam.licenseTextProvider);
        sfp.configuredBy(scanFlowParam.getPropertyProvider());
        return sfp;
    }

    public static ScanFlowParam build() {
        return new ScanFlowParam();
    }

    public File getInventoryFile() {
        return this.inventoryResource.getFile();
    }

    public ScanFlowParam using(NormalizationMetaData normalizationMetaData) {
        this.normalizationMetaData = normalizationMetaData;
        return this;
    }

    public ScanFlowParam using(LicenseTextProvider licenseTextProvider) {
        this.licenseTextProvider = licenseTextProvider;
        return this;
    }

    public ScanFlowParam withInventory(Inventory inventory) {
        this.inventoryResource = InventoryResource.fromInventory((Inventory)inventory);
        return this;
    }

    public ScanFlowParam withInventory(InventoryResource inventoryResource) {
        this.inventoryResource = inventoryResource;
        return this;
    }

    public ScanFlowParam using(File analysisBaseDir) {
        this.analysisBaseDir = analysisBaseDir;
        return this;
    }

    public ScanFlowParam publishResultsTo(File resultTargetDir) {
        this.resultTargetDir = resultTargetDir;
        return this;
    }

    public File getResultTargetDir() {
        return this.resultTargetDir;
    }

    public int getScanThreads() {
        return Integer.parseInt(this.getPropertyProvider().getProperty("workbench.scanner.threads", "4"));
    }

    public NormalizationMetaData getNormalizationMetaData() {
        return this.normalizationMetaData;
    }

    public LicenseTextProvider getLicenseTextProvider() {
        return this.licenseTextProvider;
    }

    public File getAnalysisBaseDir() {
        return this.analysisBaseDir;
    }

    public InventoryResource getInventoryResource() {
        return this.inventoryResource;
    }
}

