/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow;

import com.metaeffekt.artifact.analysis.bom.BomConstants;
import com.metaeffekt.artifact.analysis.bom.parameters.ExportParameters;
import com.metaeffekt.artifact.analysis.bom.spdx.DocumentSpec;
import com.metaeffekt.artifact.analysis.bom.spdx.SpdxExporter;
import com.metaeffekt.artifact.analysis.flow.SpdxDocumentFlowParam;
import com.metaeffekt.artifact.analysis.model.PropertyProvider;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.terms.model.LicenseTextProvider;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.resource.InventoryResource;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpdxDocumentFlow {
    private static final Logger LOG = LoggerFactory.getLogger(SpdxDocumentFlow.class);

    public void process(SpdxDocumentFlowParam spdxDocumentFlowParam) throws IOException {
        SpdxExporter spdxExporter = new SpdxExporter(spdxDocumentFlowParam.getNormalizationMetaData(), spdxDocumentFlowParam.getLicenseTextProvider(), ExportParameters.builder().build());
        try {
            spdxExporter.exportToSpdxDocument(spdxDocumentFlowParam.getInventoryResource().getInventory(), spdxDocumentFlowParam.getTargetSpdxFile(), spdxDocumentFlowParam.getDocumentSpec(), true);
        }
        catch (RuntimeException e) {
            LOG.warn("Cannot produce SPDX document [{}]", (Object)spdxDocumentFlowParam.getTargetSpdxFile(), (Object)e);
        }
    }

    public static void produceSpdxDocument(InventoryResource inventoryResource, String name, File targetSpdxDocumentFile, NormalizationMetaData normalizationMetaData, LicenseTextProvider licenseTextProvider, PropertyProvider propertyProvider) throws IOException {
        FileUtils.forceMkdirParent((File)targetSpdxDocumentFile);
        String organization = propertyProvider.getProperty("spdx.document.organization", null);
        String person = propertyProvider.getProperty("spdx.document.person", null);
        String tool = propertyProvider.getProperty("spdx.document.tool", "metaeffekt Kontinuum SPDX Exporter");
        String uriPrefix = propertyProvider.getProperty("spdx.document.uri.prefix", null);
        String description = propertyProvider.getProperty("spdx.document.description", null);
        String comment = propertyProvider.getProperty("spdx.document.comment", null);
        String spdxLicenseListVersion = propertyProvider.getProperty("spdx.document.license.list.version", null);
        String organizationUrl = propertyProvider.getProperty("spdx.document.organization.url", null);
        DocumentSpec documentSpec = new DocumentSpec(name, uriPrefix + UUID.randomUUID(), organization, organizationUrl).withDescription(description).withComment(comment).withSpdxLicenseListVersion(spdxLicenseListVersion).byPerson(person).usingTool(tool).usingFormat(BomConstants.Format.JSON);
        SpdxDocumentFlowParam spdxDocumentFlowParam = SpdxDocumentFlowParam.build().using(inventoryResource).using(normalizationMetaData).using(licenseTextProvider).documenting(documentSpec).writing(targetSpdxDocumentFile);
        new SpdxDocumentFlow().process(spdxDocumentFlowParam);
    }
}

