/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow.ng;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.metaeffekt.artifact.analysis.flow.ng.exception.DecryptionImpossibleException;
import com.metaeffekt.artifact.analysis.flow.ng.keyholder.UserKeysForConsumer;
import com.metaeffekt.artifact.analysis.flow.ng.keyholder.UserKeysForSupplier;
import com.metaeffekt.artifact.analysis.flow.ng.keyholder.UserKeysWithHmacSecret;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.crypto.Mac;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationFunction;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.AESWrapEngine;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.kems.RSAKEMExtractor;
import org.bouncycastle.crypto.kems.RSAKEMGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.BigIntegers;

public class DecryptableKeyslot {
    @JsonProperty(value="encapsulatedKek")
    private byte[] encapsulatedKek;
    @JsonProperty(value="wrappedContentKey")
    private byte[] wrappedContentKey;
    @JsonProperty(value="slotHmac")
    private byte[] slotHmac;
    @JsonProperty(value="contentKeyLength")
    private byte[] contentKeyLength;
    SecureRandom secureRandom = new SecureRandom();

    public static DecryptableKeyslot createDecryptableKeyslot(byte[] contentKey, UserKeysForSupplier userKeysForSupplier) {
        return DecryptableKeyslot.createDecryptableKeyslot(contentKey, userKeysForSupplier, new SecureRandom());
    }

    public static DecryptableKeyslot createDecryptableKeyslot(byte[] contentKey, UserKeysForSupplier userKeysForSupplier, SecureRandom secureRandom) {
        RSAKEMGenerator generator = new RSAKEMGenerator(contentKey.length, (DerivationFunction)new KDF2BytesGenerator((Digest)new SHA256Digest()), secureRandom);
        SecretWithEncapsulation secretWithEncapsulation = generator.generateEncapsulated((AsymmetricKeyParameter)userKeysForSupplier.getRsaPublicKey());
        AESWrapEngine aesWrapEngine = new AESWrapEngine();
        KeyParameter keyParameter = new KeyParameter(secretWithEncapsulation.getSecret());
        aesWrapEngine.init(true, (CipherParameters)keyParameter);
        byte[] wrappedContentKey = aesWrapEngine.wrap(contentKey, 0, contentKey.length);
        DecryptableKeyslot entry = new DecryptableKeyslot();
        entry.encapsulatedKek = secretWithEncapsulation.getEncapsulation();
        entry.wrappedContentKey = wrappedContentKey;
        entry.contentKeyLength = ByteBuffer.allocate(2).putShort((short)contentKey.length).array();
        entry.slotHmac = entry.calculateHmac(userKeysForSupplier);
        return entry;
    }

    public byte[] getContentKeyUsing(UserKeysForConsumer userKeys) throws InvalidCipherTextException {
        if (!this.checkHmac(userKeys)) {
            throw new DecryptionImpossibleException("Can't decrypt this slot using the provided keys");
        }
        short keyLength = ByteBuffer.wrap(this.contentKeyLength).getShort();
        RSAKEMExtractor extractor = new RSAKEMExtractor(userKeys.getRsaPrivateKey(), (int)keyLength, this.getSha256Kdf2());
        byte[] kek = extractor.extractSecret(this.encapsulatedKek);
        AESWrapEngine aesWrapEngine = new AESWrapEngine();
        KeyParameter keyParameter = new KeyParameter(kek);
        aesWrapEngine.init(false, (CipherParameters)keyParameter);
        try {
            return aesWrapEngine.unwrap(this.wrappedContentKey, 0, this.wrappedContentKey.length);
        }
        catch (InvalidCipherTextException e) {
            throw new DecryptionImpossibleException("Can't unwrap. Possible tampering detected!", (Exception)((Object)e));
        }
    }

    private DerivationFunction getSha256Kdf2() {
        return new KDF2BytesGenerator((Digest)new SHA256Digest());
    }

    public static DecryptableKeyslot generateBogusKeyslot(SecureRandom random, int realContentKeyLength) {
        byte[] bogusContentKey = new byte[realContentKeyLength];
        random.nextBytes(bogusContentKey);
        byte[] bogusHmacKey = new byte[32];
        random.nextBytes(bogusHmacKey);
        BigInteger bogusPublicMod = BigIntegers.createRandomBigInteger((int)4096, (SecureRandom)random);
        BigInteger bogusCiphertext = BigIntegers.createRandomInRange((BigInteger)BigInteger.ZERO, (BigInteger)bogusPublicMod, (SecureRandom)random);
        DecryptableKeyslot entry = new DecryptableKeyslot();
        entry.encapsulatedKek = BigIntegers.asUnsignedByteArray((int)((bogusPublicMod.bitLength() + 7) / 8), (BigInteger)bogusCiphertext);
        byte[] bogusEncapsulatedSecret = new byte[realContentKeyLength];
        random.nextBytes(bogusEncapsulatedSecret);
        AESWrapEngine aesWrapEngine = new AESWrapEngine();
        KeyParameter keyParameter = new KeyParameter(bogusEncapsulatedSecret);
        aesWrapEngine.init(true, (CipherParameters)keyParameter);
        entry.wrappedContentKey = aesWrapEngine.wrap(bogusContentKey, 0, realContentKeyLength);
        entry.slotHmac = entry.calculateHmac(bogusHmacKey);
        entry.contentKeyLength = ByteBuffer.allocate(2).putShort((short)realContentKeyLength).array();
        return entry;
    }

    public boolean checkHmac(UserKeysWithHmacSecret userKeys) {
        if (this.slotHmac == null || this.slotHmac.length == 0) {
            return false;
        }
        return this.hmacEquals(this.calculateHmac(userKeys));
    }

    private boolean hmacEquals(byte[] toCompare) {
        if (toCompare == null || toCompare.length == 0) {
            return false;
        }
        byte[] randomKey = new byte[32];
        this.secureRandom.nextBytes(randomKey);
        Mac hmacGenerator = HmacUtils.getInitializedMac((HmacAlgorithms)HmacAlgorithms.HMAC_SHA_512, (byte[])randomKey);
        byte[] doubleMacToCompare = hmacGenerator.doFinal(toCompare);
        byte[] doubleMacInternal = hmacGenerator.doFinal(this.slotHmac);
        return MessageDigest.isEqual(doubleMacInternal, doubleMacToCompare);
    }

    private byte[] calculateHmac(UserKeysWithHmacSecret userKeys) {
        return this.calculateHmac(userKeys.getHmacSecretKey());
    }

    private byte[] calculateHmac(byte[] key) {
        Mac hmacGenerator = HmacUtils.getInitializedMac((HmacAlgorithms)HmacAlgorithms.HMAC_SHA_256, (byte[])key);
        hmacGenerator.update(this.encapsulatedKek);
        hmacGenerator.update(this.wrappedContentKey);
        hmacGenerator.update(this.contentKeyLength);
        return hmacGenerator.doFinal();
    }

    public byte[] getEncapsulatedKek() {
        return (byte[])this.encapsulatedKek.clone();
    }

    public byte[] getWrappedContentKey() {
        return (byte[])this.wrappedContentKey.clone();
    }

    public byte[] getSlotHmac() {
        return (byte[])this.slotHmac.clone();
    }

    public byte[] getContentKeyLength() {
        return this.contentKeyLength;
    }
}

