/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow.ng;

import com.metaeffekt.artifact.analysis.flow.ng.keyholder.UserKeysForConsumer;
import com.metaeffekt.artifact.analysis.flow.ng.keyholder.UserKeysForSupplier;
import com.metaeffekt.artifact.analysis.flow.ng.keyholder.UserKeysStorage;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class EncryptedArtifactProducerUtils {
    public static void assertEquals(Object o1, Object o2) {
        if (!Objects.equals(o1, o2)) {
            throw new RuntimeException("Self-test failed. " + o1 + " does not equal " + o2);
        }
    }

    public static void assertWordlistEquals(Collection<String> actualWordlist, Collection<String> expectedWordlist) {
        List readWordlistArray = actualWordlist.stream().sorted().collect(Collectors.toList());
        List generatedWordlistArray = expectedWordlist.stream().sorted().collect(Collectors.toList());
        for (int i = 0; i < actualWordlist.size(); ++i) {
            EncryptedArtifactProducerUtils.assertEquals(readWordlistArray.get(i), generatedWordlistArray.get(i));
        }
    }

    private static void mkdirOrErr(File ... dirs) throws IOException {
        for (File toMkdir : dirs) {
            EncryptedArtifactProducerUtils.mkdirOrErr(toMkdir);
        }
    }

    public static void writeDummyKeys(File dummyKeyForSupplierFile, File dummyKeyForConsumerFile, UserKeysForSupplier keyForSupplier, UserKeysForConsumer keyForConsumer, String temporaryPassword) throws IOException {
        dummyKeyForSupplierFile.deleteOnExit();
        dummyKeyForConsumerFile.deleteOnExit();
        EncryptedArtifactProducerUtils.mkdirOrErr(dummyKeyForSupplierFile.getParentFile(), dummyKeyForConsumerFile.getParentFile());
        UserKeysStorage.writeUserKeys(keyForSupplier, dummyKeyForSupplierFile);
        UserKeysStorage.writeUserKeys(keyForConsumer, temporaryPassword, dummyKeyForConsumerFile);
    }

    public static void mkdirOrErr(File toMkdir) throws IOException {
        if (!toMkdir.exists() && !toMkdir.mkdir()) {
            throw new IOException("Couldn't create '" + toMkdir.getPath() + "'");
        }
        if (!toMkdir.isDirectory()) {
            throw new IOException("Should-be directory '" + toMkdir.getPath() + "' isn't a directory");
        }
    }

    public static void filterCustomerMetaData(NormalizationMetaData normalizationMetaData) {
        for (TermsMetaData tmd : new HashSet(normalizationMetaData.getLicenseMetaDataMap().values())) {
            if (!tmd.isCustomerMetaData()) continue;
            normalizationMetaData.remove(tmd);
        }
    }
}

