/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow.ng;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class StreamReadingUtils {
    public static int readOrThrow(InputStream inputStream, byte[] toReadTo) throws IOException {
        int readPos;
        int read;
        for (readPos = 0; readPos < toReadTo.length; readPos += read) {
            read = inputStream.read(toReadTo, readPos, toReadTo.length - readPos);
            if (read >= 0) {
                continue;
            }
            throw new IOException("Could not read iv from content file.");
        }
        if (readPos > toReadTo.length) {
            throw new RuntimeException("Sanity check failed: overrun while reading bytes");
        }
        return readPos;
    }

    public static boolean skipToEntry(ZipInputStream zipInputStream, String entryName) throws IOException {
        ZipEntry entry = zipInputStream.getNextEntry();
        while (entry != null) {
            if (entry.getName().equals(entryName)) {
                return true;
            }
            entry = zipInputStream.getNextEntry();
        }
        return false;
    }
}

