/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow.ng.crypt;

import com.metaeffekt.artifact.analysis.flow.ng.ContentAlgorithmParam;
import com.metaeffekt.artifact.analysis.flow.ng.crypt.ContentEncryptionKey;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.output.CloseShieldOutputStream;

public class EncryptedEntryOutputStream
extends FilterOutputStream
implements AutoCloseable {
    private boolean closed = false;
    private final ZipOutputStream underlyingZipStream;

    private EncryptedEntryOutputStream(ZipOutputStream underlyingZipStream, Cipher cipher) {
        super(new CipherOutputStream((OutputStream)CloseShieldOutputStream.wrap((OutputStream)underlyingZipStream), cipher));
        this.underlyingZipStream = underlyingZipStream;
    }

    private static byte[] getIv() {
        byte[] rawContentEncryptionIv = new byte[16];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(rawContentEncryptionIv);
        return rawContentEncryptionIv;
    }

    private static Cipher createEncryptionCipher(ContentAlgorithmParam algoParam, ContentEncryptionKey contentEncryptionKey) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, InvalidKeyException {
        Objects.requireNonNull(algoParam);
        Objects.requireNonNull(contentEncryptionKey);
        SecretKeySpec key = new SecretKeySpec(contentEncryptionKey.getRaw(), algoParam.getAlgorithm() + algoParam.getMode());
        Cipher cipher = Cipher.getInstance(algoParam.getAlgorithm() + algoParam.getMode(), algoParam.getProvider());
        byte[] iv = EncryptedEntryOutputStream.getIv();
        cipher.init(1, (Key)key, new IvParameterSpec(iv));
        return cipher;
    }

    public static EncryptedEntryOutputStream createEncryptionOutputStream(ZipOutputStream zipOutputStream, ContentAlgorithmParam algorithmParam, ContentEncryptionKey contentEncryptionKey) throws InvalidAlgorithmParameterException, NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, IOException {
        Cipher cipher = EncryptedEntryOutputStream.createEncryptionCipher(algorithmParam, contentEncryptionKey);
        zipOutputStream.write(cipher.getIV());
        zipOutputStream.flush();
        return new EncryptedEntryOutputStream(zipOutputStream, cipher);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            super.close();
            try {
                this.underlyingZipStream.closeEntry();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }
}

