/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow.ng.crypt;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.metaeffekt.artifact.analysis.flow.ng.DecryptableKeyslot;
import com.metaeffekt.artifact.analysis.flow.ng.crypt.ContentEncryptionKey;
import com.metaeffekt.artifact.analysis.flow.ng.crypt.EncryptedEntryOutputStream;
import com.metaeffekt.artifact.analysis.flow.ng.crypt.param.SupplierParameters;
import com.metaeffekt.artifact.analysis.flow.ng.exception.SelfcheckFailedException;
import com.metaeffekt.artifact.analysis.flow.ng.keyholder.UserKeysForSupplier;
import com.metaeffekt.artifact.analysis.flow.ng.keyholder.UserKeysStorage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedZipSupplier
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptedZipSupplier.class);
    private EncryptedEntryOutputStream currentEntry = null;
    protected final SupplierParameters param;
    protected final ZipOutputStream zipOutputStream;
    protected final ContentEncryptionKey contentEncryptionKey;

    public EncryptedZipSupplier(SupplierParameters param) throws IOException {
        this.param = Objects.requireNonNull(param);
        if (!param.getZipOutputFile().getParentFile().isDirectory() && !param.getZipOutputFile().getParentFile().mkdirs()) {
            LOG.error("Could not create directory [{}]", (Object)param.getZipOutputFile().getParentFile());
            throw new RuntimeException("Could not create zip's output directory.");
        }
        if (!Files.isRegularFile(param.getLicenseTextFile().toPath(), new LinkOption[0])) {
            LOG.error("The provided license text file is not a regular file.");
            throw new IllegalArgumentException("Aborting early due to unreadable license text file.");
        }
        if (!param.getLicenseTextFile().canRead()) {
            LOG.error("The provided license text file is not readable.");
            throw new IllegalArgumentException("Aborting early due to unreadable license text file.");
        }
        OutputStream fileOutputStream = Files.newOutputStream(param.getZipOutputFile().toPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        this.zipOutputStream = new ZipOutputStream(fileOutputStream);
        this.zipOutputStream.setMethod(8);
        this.zipOutputStream.setLevel(9);
        this.contentEncryptionKey = new ContentEncryptionKey();
        this.writeLicense();
        this.writeKeyslots();
    }

    protected void writeLicense() throws IOException {
        this.zipOutputStream.putNextEntry(new ZipEntry("LICENSE.txt"));
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        try (InputStream inputStream = Files.newInputStream(this.param.getLicenseTextFile().toPath(), new OpenOption[0]);){
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            CharBuffer chars = decoder.decode(ByteBuffer.wrap(bytes));
            if (StringUtils.isBlank((CharSequence)chars)) {
                LOG.warn("The provided license file appears to be blank!");
            }
            this.zipOutputStream.write(bytes);
        }
        this.zipOutputStream.closeEntry();
    }

    public EncryptedEntryOutputStream getEncryptedEntryStream(String entryName) throws IOException, InvalidAlgorithmParameterException, NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        if (this.currentEntry != null && !this.currentEntry.isClosed()) {
            this.currentEntry.close();
        }
        this.zipOutputStream.putNextEntry(new ZipEntry(entryName));
        this.currentEntry = EncryptedEntryOutputStream.createEncryptionOutputStream(this.zipOutputStream, this.param.getContentAlgorithmParam(), this.contentEncryptionKey);
        return this.currentEntry;
    }

    protected UserKeysForSupplier tryTwice(File keyfile) {
        try {
            try {
                return UserKeysStorage.readUserKeysForPublisher(keyfile, true);
            }
            catch (SelfcheckFailedException e) {
                LOG.warn("Keyfile's selfcheck failed: possibly corrupt at [{}]", (Object)keyfile.getPath());
                LOG.warn("trying to add the corrupt keyfile anyway... please investigate before release.");
                return UserKeysStorage.readUserKeysForPublisher(keyfile, false);
            }
        }
        catch (IOException e) {
            LOG.error("Could not read user key at '[{}]'", (Object)keyfile.getPath());
            throw new RuntimeException("Error while trying to read user key at '" + keyfile.getPath() + "'.", e);
        }
    }

    protected List<UserKeysForSupplier> loadUserKeys(File allowedUserKeysDir) {
        File[] keyFiles = allowedUserKeysDir.listFiles(f -> f != null && !f.isHidden());
        if (keyFiles == null) {
            return new ArrayList<UserKeysForSupplier>();
        }
        ArrayList<UserKeysForSupplier> keys = new ArrayList<UserKeysForSupplier>();
        LOG.info("Loading user keys");
        for (File keyfile : keyFiles) {
            if (!keyfile.isFile()) {
                LOG.warn("Ignoring non-file '" + keyfile.getPath() + "'.");
                continue;
            }
            if (!keyfile.getName().endsWith(".json")) {
                LOG.warn("Expected .json files for reading '" + UserKeysForSupplier.class.getName() + "' information.");
            }
            LOG.info("Granting access to user key: " + keyfile.getPath());
            keys.add(this.tryTwice(keyfile));
        }
        return keys;
    }

    protected static boolean validateKeyslots(SupplierParameters param, List<DecryptableKeyslot> keyslots) {
        if (keyslots == null || keyslots.isEmpty()) {
            throw new IllegalArgumentException("Can't validate keyslots that don't exist...");
        }
        if (keyslots.size() != param.keyslotNum) {
            return false;
        }
        byte[] contentKeyLength = keyslots.get(0).getContentKeyLength();
        int slotHmacLength = keyslots.get(0).getSlotHmac().length;
        for (DecryptableKeyslot slot : keyslots) {
            if (!Arrays.equals(contentKeyLength, slot.getContentKeyLength())) {
                return false;
            }
            if (slot.getSlotHmac().length == slotHmacLength) continue;
            return false;
        }
        return true;
    }

    private List<DecryptableKeyslot> createKeyslots() {
        List<UserKeysForSupplier> userKeysList = this.loadUserKeys(this.param.getAllowedUserKeysDir());
        if (userKeysList.isEmpty()) {
            LOG.warn("ZERO user keys have been loaded! The output will likely be useless.");
        }
        SecureRandom secureRandom = new SecureRandom();
        ArrayList keyslots = userKeysList.stream().map(k -> DecryptableKeyslot.createDecryptableKeyslot(this.contentEncryptionKey.getRaw(), k)).collect(Collectors.toCollection(ArrayList::new));
        if (keyslots.size() > this.param.keyslotNum) {
            LOG.error("Privacy of the number of existing keys is revealed in index: generated more than keyslotNum.");
        } else if (keyslots.size() == this.param.keyslotNum) {
            LOG.warn("Keyslots EXACTLY fill the maximum allowed number! keyslotNum must be increased soon.");
        } else {
            while (keyslots.size() < this.param.keyslotNum) {
                keyslots.add(DecryptableKeyslot.generateBogusKeyslot(secureRandom, this.contentEncryptionKey.getLength()));
            }
        }
        Collections.shuffle(keyslots, secureRandom);
        if (!EncryptedZipSupplier.validateKeyslots(this.param, keyslots)) {
            throw new RuntimeException("Generated keyslots failed to validate");
        }
        return keyslots;
    }

    private void writeKeyslots() throws IOException {
        List<DecryptableKeyslot> keyslots = this.createKeyslots();
        this.zipOutputStream.putNextEntry(new ZipEntry("ae-dataset-keyslots.ndjson"));
        try (CloseShieldOutputStream closeShield = CloseShieldOutputStream.wrap((OutputStream)this.zipOutputStream);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)closeShield, StandardCharsets.UTF_8);
             SequenceWriter seq = new ObjectMapper().writerFor(DecryptableKeyslot.class).withRootValueSeparator("\n").writeValues((Writer)writer);){
            seq.writeAll(keyslots);
            seq.flush();
            writer.write(10);
        }
        this.zipOutputStream.closeEntry();
    }

    @Override
    public void close() throws IOException {
        this.zipOutputStream.close();
    }
}

