/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow.ng.crypt.param;

import com.metaeffekt.artifact.analysis.flow.ng.ContentAlgorithmParam;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderParameters {
    private static final Logger LOG = LoggerFactory.getLogger(ProviderParameters.class);
    private final ContentAlgorithmParam contentAlgorithmParam;
    private final String password;
    private final File encryptedZipPackage;
    private final File userKeysFile;

    public ProviderParameters(ContentAlgorithmParam contentAlgorithmParam, String password, File userKeysFile, File encryptedZipPackage) {
        if (StringUtils.isBlank((String)password)) {
            LOG.warn("Provided password is blank.");
        }
        if (!Files.isRegularFile(encryptedZipPackage.toPath(), new LinkOption[0])) {
            LOG.warn("Dataset package not readable.");
        }
        if (!Files.isRegularFile(userKeysFile.toPath(), new LinkOption[0])) {
            LOG.warn("The user keys file is not readable.");
        }
        this.contentAlgorithmParam = contentAlgorithmParam;
        this.password = password;
        this.userKeysFile = userKeysFile;
        this.encryptedZipPackage = encryptedZipPackage;
    }

    public ContentAlgorithmParam getContentAlgorithmParam() {
        return this.contentAlgorithmParam;
    }

    public String getPassword() {
        return this.password;
    }

    public File getUserKeysFile() {
        return this.userKeysFile;
    }

    public File getEncryptedZipPackage() {
        return this.encryptedZipPackage;
    }
}

