/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow.ng.keyholder;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.metaeffekt.artifact.analysis.flow.ng.StreamReadingUtils;
import com.metaeffekt.artifact.analysis.flow.ng.exception.SelfcheckFailedException;
import com.metaeffekt.artifact.analysis.flow.ng.keyholder.UserKeysForConsumer;
import com.metaeffekt.artifact.analysis.flow.ng.keyholder.UserKeysForSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.TreeMap;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PrivateKeyInfoFactory;

public class UserKeysStorage {
    public static Cipher getConsumerKeyEncryptionCipher(Key key, byte[] iv) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance("AES/EAX/NoPadding", "BC");
        if (iv == null) {
            throw new IllegalArgumentException("IV should not be null with this scheme.");
        }
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        cipher.init(1, key, spec);
        return cipher;
    }

    public static Cipher getConsumerKeyDecryptionCipher(Key key, byte[] iv) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance("AES/EAX/NoPadding", "BC");
        if (iv == null) {
            throw new IllegalArgumentException("IV should not be null with this scheme.");
        }
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        cipher.init(2, key, spec);
        return cipher;
    }

    public static Key passwordTo16ByteKey(String password, byte[] untrustedSalt) {
        HKDFParameters param = new HKDFParameters(password.getBytes(StandardCharsets.UTF_8), null, untrustedSalt);
        HKDFBytesGenerator gen = new HKDFBytesGenerator((Digest)new SHA256Digest());
        gen.init((DerivationParameters)param);
        byte[] output = new byte[16];
        if (gen.generateBytes(output, 0, 16) != 16) {
            throw new RuntimeException("Sanity check failed: HKDF didn't claim to have written the correct 16 bytes.");
        }
        return new SecretKeySpec(output, "AES");
    }

    public static String getSelfcheckSum(String encodedAsymmetric, String encodedSecret) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        digest.update(encodedAsymmetric.getBytes(StandardCharsets.UTF_8));
        digest.update(encodedSecret.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(digest.digest());
    }

    public static void writeUserKeys(UserKeysForSupplier userKeysForSupplier, File outputFile) throws IOException {
        TreeMap<String, String> interMap = UserKeysStorage.toInterMap(userKeysForSupplier);
        ObjectMapper mapper = new ObjectMapper();
        try (OutputStream fos = Files.newOutputStream(outputFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            mapper.writerWithDefaultPrettyPrinter().writeValue(fos, interMap);
        }
    }

    public static void writeUserKeys(UserKeysForConsumer userKeysForConsumer, String password, File outputFile) throws IOException {
        TreeMap<String, String> interMap = UserKeysStorage.toInterMap(userKeysForConsumer);
        byte[] iv = new byte[16];
        new SecureRandom().nextBytes(iv);
        Key derivedEncryptionKey = UserKeysStorage.passwordTo16ByteKey(password, iv);
        try (OutputStream fos = Files.newOutputStream(outputFile.toPath(), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            fos.write(iv);
            Cipher cipher = UserKeysStorage.getConsumerKeyEncryptionCipher(derivedEncryptionKey, iv);
            ObjectMapper mapper = new ObjectMapper();
            try (CipherOutputStream cipherOutputStream = new CipherOutputStream(fos, cipher);){
                mapper.writerWithDefaultPrettyPrinter().writeValue((OutputStream)cipherOutputStream, interMap);
            }
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public static UserKeysForSupplier readUserKeysForPublisher(File inputFile, boolean doSelfcheck) throws IOException, SelfcheckFailedException {
        TreeMap interMap;
        if (!inputFile.isFile()) {
            throw new IOException("Input should be a file.");
        }
        ObjectMapper mapper = new ObjectMapper();
        try (InputStream fis = Files.newInputStream(inputFile.toPath(), new OpenOption[0]);
             InputStreamReader inputReader = new InputStreamReader(fis, StandardCharsets.UTF_8);){
            MapType stringMap = mapper.getTypeFactory().constructMapType(TreeMap.class, String.class, String.class);
            interMap = (TreeMap)mapper.readValue((Reader)inputReader, (JavaType)stringMap);
        }
        if (interMap == null) {
            throw new RuntimeException("Should not happen: interMap was null after reading or throwing.");
        }
        return UserKeysStorage.fromInterMapForPublisher(interMap, doSelfcheck);
    }

    public static UserKeysForConsumer readUserKeysForConsumer(File inputFile, String password, boolean doSelfcheck) throws IOException, SelfcheckFailedException {
        String jsonString;
        if (!inputFile.isFile()) {
            throw new IOException("Input should be a file. got " + inputFile.getAbsolutePath());
        }
        try (InputStream fis = Files.newInputStream(inputFile.toPath(), StandardOpenOption.READ);){
            byte[] iv = new byte[16];
            StreamReadingUtils.readOrThrow(fis, iv);
            Key key = UserKeysStorage.passwordTo16ByteKey(password, iv);
            SecretKeySpec secretKeySpec = (SecretKeySpec)key;
            Cipher decryptionCipher = UserKeysStorage.getConsumerKeyDecryptionCipher(key, iv);
            try (CipherInputStream cipherInputStream = new CipherInputStream(fis, decryptionCipher);
                 InputStreamReader inputReader = new InputStreamReader((InputStream)cipherInputStream, StandardCharsets.UTF_8);){
                jsonString = IOUtils.toString((Reader)inputReader);
            }
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
        ObjectMapper mapper = new ObjectMapper();
        MapType stringMap = mapper.getTypeFactory().constructMapType(TreeMap.class, String.class, String.class);
        TreeMap interMap = (TreeMap)mapper.readValue(jsonString, (JavaType)stringMap);
        if (interMap == null) {
            throw new RuntimeException("Should not happen: interMap was null after reading or throwing.");
        }
        return UserKeysStorage.fromInterMapForUser(interMap, doSelfcheck);
    }

    public static UserKeysForConsumer fromInterMapForUser(TreeMap<String, String> interMap, boolean doSelfcheck) throws IOException, SelfcheckFailedException {
        String base64Pkcs8EncodedPrivateKey = interMap.get("rsaPrivateKey");
        String encodedHmacKey = interMap.get("secretHmacKey");
        String receivedSelfcheck = interMap.get("selfcheckSum");
        if (doSelfcheck && !receivedSelfcheck.equals(UserKeysStorage.getSelfcheckSum(base64Pkcs8EncodedPrivateKey, encodedHmacKey))) {
            throw new SelfcheckFailedException("Keyfile's self-check failed: Keyfile is corrupt and might not work!");
        }
        Base64.Decoder decoder = Base64.getDecoder();
        AsymmetricKeyParameter privateKey = PrivateKeyFactory.createKey((byte[])decoder.decode(base64Pkcs8EncodedPrivateKey));
        return new UserKeysForConsumer((RSAKeyParameters)privateKey, decoder.decode(encodedHmacKey));
    }

    public static UserKeysForSupplier fromInterMapForPublisher(TreeMap<String, String> interMap, boolean doSelfcheck) throws IOException, SelfcheckFailedException {
        String base64DerEncodedPublicKey = interMap.get("rsaPublicKey");
        String encodedHmacKey = interMap.get("secretHmacKey");
        if (base64DerEncodedPublicKey == null) {
            throw new RuntimeException("rsaPublicKey from json can't be null");
        }
        if (encodedHmacKey == null) {
            throw new RuntimeException("secretHmacKey from json can't be null");
        }
        String receivedSelfcheck = interMap.get("selfcheckSum");
        if (doSelfcheck && !receivedSelfcheck.equals(UserKeysStorage.getSelfcheckSum(base64DerEncodedPublicKey, encodedHmacKey))) {
            throw new SelfcheckFailedException("Keyfile's self-check failed: Keyfile is corrupt and might not work!");
        }
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] derEncodedPublicKey = decoder.decode(base64DerEncodedPublicKey);
        ASN1Primitive derPublicKeyPrimitive = ASN1Primitive.fromByteArray((byte[])derEncodedPublicKey);
        RSAPublicKey rsaPublicKey = RSAPublicKey.getInstance((Object)derPublicKeyPrimitive);
        RSAKeyParameters rsaPublicKeyParam = new RSAKeyParameters(false, rsaPublicKey.getModulus(), rsaPublicKey.getPublicExponent());
        return new UserKeysForSupplier(rsaPublicKeyParam, decoder.decode(encodedHmacKey));
    }

    public static TreeMap<String, String> toInterMap(UserKeysForSupplier userKeysForSupplier) throws IOException {
        TreeMap<String, String> interMap = new TreeMap<String, String>();
        RSAKeyParameters asymmetricPublicKey = userKeysForSupplier.getRsaPublicKey();
        RSAPublicKey asn1PublicKey = new RSAPublicKey(asymmetricPublicKey.getModulus(), asymmetricPublicKey.getExponent());
        Base64.Encoder encoder = Base64.getEncoder();
        String encodedPublicKey = encoder.encodeToString(asn1PublicKey.getEncoded("DER"));
        String encodedHmacKey = encoder.encodeToString(userKeysForSupplier.getHmacSecretKey());
        interMap.put("rsaPublicKey", encodedPublicKey);
        interMap.put("secretHmacKey", encodedHmacKey);
        interMap.put("selfcheckSum", UserKeysStorage.getSelfcheckSum(encodedPublicKey, encodedHmacKey));
        return interMap;
    }

    public static TreeMap<String, String> toInterMap(UserKeysForConsumer userKeysForConsumer) throws IOException {
        TreeMap<String, String> interMap = new TreeMap<String, String>();
        RSAKeyParameters asymmetricPrivateKey = userKeysForConsumer.getRsaPrivateKey();
        PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)asymmetricPrivateKey);
        Base64.Encoder encoder = Base64.getEncoder();
        String encodedPrivateKey = encoder.encodeToString(privateKeyInfo.getEncoded());
        String encodedHmacKey = encoder.encodeToString(userKeysForConsumer.getHmacSecretKey());
        interMap.put("rsaPrivateKey", encodedPrivateKey);
        interMap.put("secretHmacKey", encodedHmacKey);
        interMap.put("selfcheckSum", UserKeysStorage.getSelfcheckSum(encodedPrivateKey, encodedHmacKey));
        return interMap;
    }
}

