/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow.notice;

import com.metaeffekt.artifact.analysis.flow.InventoryResult;
import com.metaeffekt.artifact.analysis.flow.notice.GenerateNoticeFlowParam;
import com.metaeffekt.artifact.analysis.utils.InventoryUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.resource.InventoryResource;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.metaeffekt.common.notice.model.NoticeParameters;
import org.metaeffekt.common.notice.model.ProjectContext;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.notice.NoticeParameterProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateNoticeFlow {
    private static final Logger LOG = LoggerFactory.getLogger(GenerateNoticeFlow.class);

    public InventoryResult process(GenerateNoticeFlowParam generateNoticeFlowParam) {
        Inventory inventory = generateNoticeFlowParam.getInventoryResource().getInventory();
        for (Artifact artifact : inventory.getArtifacts()) {
            String derivedNoticeParameter = artifact.get("Derived Notice Parameter");
            GenerateNoticeFlow.adoptDeductedLicenseAndNoticeParameter(artifact, derivedNoticeParameter);
        }
        ProjectContext projectContext = new ProjectContext();
        projectContext.setLanguageMode(ProjectContext.LanguageMode.en_US);
        projectContext.setSourceMode(ProjectContext.SourceMode.ON_DEMAND);
        NoticeParameterProcessor processor = new NoticeParameterProcessor(generateNoticeFlowParam.getNormalizationMetaData());
        processor.updateNoticeFromNoticeParameter(inventory, projectContext);
        return new InventoryResult(InventoryResource.fromInventory((Inventory)inventory));
    }

    private static void adoptDeductedLicenseAndNoticeParameter(Artifact artifact, String deductedNoticeParameter) {
        NoticeParameters noticeParameters;
        if (deductedNoticeParameter != null && StringUtils.isEmpty((String)artifact.get("Notice Parameter")) && (noticeParameters = GenerateNoticeFlow.parseNoticeParameter(artifact, deductedNoticeParameter)) != null) {
            boolean adopt;
            HashSet noticeParameterAssociatedLicenses = new HashSet(noticeParameters.getAllAssociatedLicense());
            HashSet currentAssociatedLicenses = new HashSet(artifact.getLicenses());
            boolean bl = adopt = StringUtils.isEmpty((String)artifact.getLicense()) ? true : CollectionUtils.isEqualCollection(noticeParameterAssociatedLicenses, currentAssociatedLicenses);
            if (adopt) {
                GenerateNoticeFlow.adoptNoticeParameter(artifact, noticeParameters, deductedNoticeParameter);
            } else {
                LOG.warn("Cannot adopt deduced notice parameter for [{}]. Inconsistency with curated license.", (Object)artifact.deriveQualifier());
                LOG.warn("Curated:          [{}]", currentAssociatedLicenses.stream().sorted().collect(Collectors.toList()));
                LOG.warn("Notice Parameter: [{}]", noticeParameterAssociatedLicenses.stream().sorted().collect(Collectors.toList()));
            }
        }
    }

    private static NoticeParameters parseNoticeParameter(Artifact artifact, String derivedNoticeParameterYaml) {
        try {
            if (StringUtils.notEmpty((String)derivedNoticeParameterYaml)) {
                return NoticeParameters.readYaml((String)derivedNoticeParameterYaml);
            }
        }
        catch (RuntimeException e) {
            LOG.warn("Cannot parse and process notice parameter for {}.", (Object)artifact.deriveQualifier());
        }
        return null;
    }

    private static void adoptNoticeParameter(Artifact artifact, NoticeParameters noticeParameters, String originalNoticeParameterYaml) {
        if (noticeParameters != null) {
            HashSet allAssociatedLicense = new HashSet(noticeParameters.getAllAssociatedLicense());
            String associatedLicensesFromNoticeParameter = InventoryUtils.joinLicenses(allAssociatedLicense);
            artifact.setLicense(associatedLicensesFromNoticeParameter);
            artifact.set("Notice Parameter", originalNoticeParameterYaml);
        }
    }
}

