/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow.notice;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.metaeffekt.common.notice.model.ComponentDefinition;
import org.metaeffekt.common.notice.model.NoticeParameters;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoticeParameterPostProcessing {
    private static final Logger LOG = LoggerFactory.getLogger(NoticeParameterPostProcessing.class);

    public void postProcessNoticeParameter(Inventory inventory) {
        int i = 1;
        for (Artifact artifact : inventory.getArtifacts()) {
            LOG.debug("Postprocessing notice parameter for {} ({}/{})", new Object[]{artifact.deriveQualifier(), i++, inventory.getArtifacts().size()});
            try {
                String derivedNoticeParameter = artifact.get("Derived Notice Parameter");
                if (!StringUtils.hasText((String)derivedNoticeParameter)) continue;
                NoticeParameters noticeParameters = NoticeParameters.readYaml((String)derivedNoticeParameter);
                this.postProcessNoticeParameter(noticeParameters);
                artifact.set("Derived Notice Parameter", noticeParameters.toYamlString());
            }
            catch (Exception e) {
                LOG.warn("Failure processing notice parameter for artifact {}", (Object)artifact.getId(), (Object)e);
            }
        }
    }

    public NoticeParameters postProcessNoticeParameter(NoticeParameters noticeParameter) {
        List copyrights;
        if (noticeParameter == null) {
            return null;
        }
        ComponentDefinition rootComponent = noticeParameter.getComponent();
        if (rootComponent == null) {
            return null;
        }
        HashMap<String, ComponentDefinition> associatedLicenseSet = new HashMap<String, ComponentDefinition>();
        associatedLicenseSet.put(rootComponent.toStringKey(), rootComponent);
        if (noticeParameter.getSubcomponents() != null) {
            ArrayList toBeRemoved = new ArrayList();
            for (ComponentDefinition subcomponent : noticeParameter.getSubcomponents()) {
                String key = subcomponent.toStringKey();
                if (associatedLicenseSet.containsKey(key)) {
                    ComponentDefinition component = noticeParameter.findComponent((ComponentDefinition)associatedLicenseSet.get(key));
                    if (component != null && subcomponent.hasCopyrights()) {
                        component.getCopyrights().addAll(subcomponent.getCopyrights());
                    }
                    toBeRemoved.add(subcomponent);
                    continue;
                }
                associatedLicenseSet.put(subcomponent.toStringKey(), subcomponent);
            }
            noticeParameter.getSubcomponents().removeAll(toBeRemoved);
        }
        this.filterComponentDefinition(rootComponent);
        if (noticeParameter.getSubcomponents() != null) {
            for (ComponentDefinition subcomponent : noticeParameter.getSubcomponents()) {
                this.filterComponentDefinition(subcomponent);
            }
        }
        if (noticeParameter.getUnassignedInformation() != null && (copyrights = noticeParameter.getUnassignedInformation().getCopyrights()) != null) {
            noticeParameter.getUnassignedInformation().setCopyrights(copyrights.stream().distinct().collect(Collectors.toList()));
        }
        return noticeParameter;
    }

    private void filterComponentDefinition(ComponentDefinition componentDefinition) {
        componentDefinition.setAssociatedLicenses(componentDefinition.getAssociatedLicenses().stream().distinct().collect(Collectors.toList()));
        componentDefinition.setCopyrights(componentDefinition.getCopyrights().stream().distinct().collect(Collectors.toList()));
    }
}

