/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.workbench;

import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.metaeffekt.common.notice.model.ComponentDefinition;
import org.metaeffekt.common.notice.model.NoticeParameters;
import org.metaeffekt.core.inventory.InventoryUtils;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.notice.NoticeParameterProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryTransformer {
    private static final Logger LOG = LoggerFactory.getLogger(InventoryTransformer.class);
    private static final String NOTICE_PARAMETER = "Notice Parameter";
    private Set<String> reportedLicenses = new HashSet<String>();
    private final NormalizationMetaData normalizationMetaData;

    public InventoryTransformer(NormalizationMetaData normalizationMetaData) {
        this.normalizationMetaData = normalizationMetaData;
    }

    public Inventory updateCanonicalNamesInInventory(Inventory inventory) {
        if (inventory != null) {
            this.updateLicensesInInventory(inventory);
            this.updateLicensesInNoticeParam(inventory);
        }
        return inventory;
    }

    private Inventory updateLicensesInInventory(Inventory inventory) {
        for (Artifact artifact : inventory.getArtifacts()) {
            this.updateLicense(artifact);
        }
        return inventory;
    }

    private void updateLicense(Artifact artifact) {
        List<String> updatedCanonicalNames = this.updateLicenses(artifact.getLicenses());
        artifact.setLicense(InventoryUtils.joinLicenses(updatedCanonicalNames));
    }

    private Inventory updateLicensesInNoticeParam(Inventory inventory) {
        NoticeParameterProcessor noticeParameterProcessor = new NoticeParameterProcessor(null);
        for (Artifact artifact : inventory.getArtifacts()) {
            try {
                if (artifact.get(NOTICE_PARAMETER) == null) continue;
                NoticeParameters param = noticeParameterProcessor.readNoticeParameter(artifact.get(NOTICE_PARAMETER));
                this.updateNoticeParameter(param);
                artifact.set(NOTICE_PARAMETER, param.toYamlString());
            }
            catch (Exception e) {
                LOG.warn("Cannot process notice parameter for artifact {}.", (Object)artifact.deriveQualifier(), (Object)e);
            }
        }
        return inventory;
    }

    public void updateNoticeParameter(NoticeParameters param) {
        this.updateComponentDefinition(param.getComponent());
        if (param.getSubcomponents() != null) {
            for (ComponentDefinition subcomponent : param.getSubcomponents()) {
                this.updateComponentDefinition(subcomponent);
            }
        }
    }

    private void updateComponentDefinition(ComponentDefinition component) {
        if (component == null) {
            return;
        }
        component.setAssociatedLicenses(this.updateLicenses(component.getAssociatedLicenses()));
        List effectiveLicenses = component.getEffectiveLicenses();
        if (effectiveLicenses != null && !effectiveLicenses.isEmpty()) {
            component.setEffectiveLicenses(this.updateLicenses(effectiveLicenses));
        }
    }

    public List<String> updateLicenses(Collection<String> licenseList) {
        ArrayList<String> updatedCanonicalNames = new ArrayList<String>();
        for (String license : licenseList) {
            for (String tokenizedLicense : InventoryUtils.tokenizeLicense((String)license, (boolean)false, (boolean)true)) {
                ArrayList<String> multiLicense = new ArrayList<String>();
                for (String atomicLicense : InventoryUtils.tokenizeLicense((String)tokenizedLicense, (boolean)false, (boolean)false)) {
                    multiLicense.add(this.getUpdatedCanonicalName(atomicLicense));
                }
                String resultLicenseExpression = StringUtils.join(multiLicense, (String)" + ");
                updatedCanonicalNames.add(resultLicenseExpression);
            }
        }
        return updatedCanonicalNames;
    }

    public String transformLicenseExpression(String licenseExpression) {
        List licenseList = InventoryUtils.tokenizeLicense((String)licenseExpression, (boolean)false, (boolean)true);
        return InventoryUtils.joinLicenses(this.transformLicenses(licenseList));
    }

    public List<String> transformLicenses(List<String> licenseList) {
        ArrayList<String> collectedSubExpressions = new ArrayList<String>();
        for (String tokenizedLicenseExpression : licenseList) {
            LinkedHashSet<String> multiLicense = new LinkedHashSet<String>();
            for (String atomicLicense : InventoryUtils.tokenizeLicense((String)tokenizedLicenseExpression, (boolean)false, (boolean)false)) {
                multiLicense.add(this.getUpdatedCanonicalName(atomicLicense));
            }
            String resultLicenseExpression = StringUtils.join(multiLicense, (String)" + ");
            collectedSubExpressions.add(resultLicenseExpression);
        }
        return collectedSubExpressions.stream().collect(Collectors.toList());
    }

    public String getUpdatedCanonicalName(String license) {
        return this.normalizationMetaData.getUpdatedCanonicalName(license);
    }
}

