/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.workbench;

import com.metaeffekt.artifact.analysis.utils.InventorySearch;
import com.metaeffekt.artifact.analysis.utils.InventoryUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.workbench.InventoryTransformer;
import com.metaeffekt.artifact.analysis.workbench.WorkbenchUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;

public class ProjectInventoryFilter {
    private boolean validate = true;
    private boolean enableUseDerivedLicense = false;
    private boolean enableInherit = true;
    private boolean enableAddComponentNameAndVersion = true;
    private boolean enableApplyCurationData = false;

    public void process(Inventory projectInventory, Inventory referenceInventory) {
        if (this.enableAddComponentNameAndVersion) {
            InventoryUtils.deriveComponentNamesAndVersions((Inventory)projectInventory);
        }
        if (this.enableApplyCurationData) {
            this.applyCurationData(projectInventory, referenceInventory);
        }
        if (this.enableInherit) {
            InventoryUtils.inheritInformationFromReferenceInventory((Inventory)projectInventory, (InventorySearch)new InventorySearch(referenceInventory));
        }
        if (this.enableUseDerivedLicense) {
            this.useDerivedLicenses(projectInventory);
        }
        this.postProcess(projectInventory);
    }

    private void applyCurationData(Inventory inventory, Inventory referenceInventory) {
        if (referenceInventory == null) {
            return;
        }
        InventorySearch referenceInventorySearch = new InventorySearch(referenceInventory);
        for (Artifact artifact : inventory.getArtifacts()) {
            artifact.deriveArtifactId();
            Artifact referenceMatch = referenceInventorySearch.findArtifactByIdAndChecksum(artifact);
            if (referenceMatch == null) {
                referenceMatch = referenceInventorySearch.findArtifactById(artifact);
            }
            if (referenceMatch == null) {
                referenceMatch = referenceInventorySearch.findArtifactWildcardMatchingId(artifact);
            }
            if (referenceMatch == null) continue;
            Artifact referenceClone = new Artifact(referenceMatch);
            referenceClone.setRootPaths(new HashSet());
            referenceClone.set("Path is Asset", null);
            if ("*".equals(referenceClone.getVersion())) {
                referenceClone.setVersion(null);
            }
            if (StringUtils.hasText((String)referenceClone.getComponent())) {
                artifact.setComponent(null);
            }
            if (StringUtils.hasText((String)referenceClone.getVersion())) {
                artifact.setVersion(null);
            }
            if (StringUtils.hasText((String)referenceClone.getLicense())) {
                artifact.setLicense(null);
            }
            if (StringUtils.hasText((String)referenceClone.get("Notice Parameter"))) {
                artifact.set("Notice Parameter", null);
            }
            artifact.merge(referenceClone);
        }
    }

    private void postProcess(Inventory projectInventory) {
        InventoryTransformer transformer = new InventoryTransformer(InventoryUtils.getNormalizationMetaData());
        transformer.updateCanonicalNamesInInventory(projectInventory);
        this.shareLicenseInPackageGroup(projectInventory);
        WorkbenchUtils.addLicenseData(projectInventory, false, true);
    }

    private void shareLicenseInPackageGroup(Inventory filteredInventory) {
        String license;
        String packageGroup;
        HashMap<String, String> packageGroupToLicenseMap = new HashMap<String, String>();
        for (Artifact artifact : filteredInventory.getArtifacts()) {
            packageGroup = artifact.get("Package Group");
            if (StringUtils.isEmpty((String)packageGroup)) {
                packageGroup = artifact.getComponent();
            }
            license = artifact.getLicense();
            if (!StringUtils.hasText((String)packageGroup) || !StringUtils.hasText((String)license)) continue;
            packageGroupToLicenseMap.put(packageGroup, license);
        }
        for (Artifact artifact : filteredInventory.getArtifacts()) {
            packageGroup = artifact.get("Package Group");
            if (StringUtils.isEmpty((String)packageGroup)) {
                packageGroup = artifact.getComponent();
            }
            license = artifact.getLicense();
            if (!StringUtils.hasText((String)packageGroup) || StringUtils.hasText((String)license)) continue;
            artifact.setLicense((String)packageGroupToLicenseMap.get(packageGroup));
        }
    }

    private void useDerivedLicenses(Inventory filteredInventory) {
        for (Artifact artifact : filteredInventory.getArtifacts()) {
            if (!StringUtils.isEmpty((String)artifact.getLicense())) continue;
            ArrayList<String> aggregatedLicenses = new ArrayList<String>();
            this.aggregateLicenses(artifact, "Derived Licenses", aggregatedLicenses);
            this.aggregateLicenses(artifact, "Package Specified License (mapped)", aggregatedLicenses);
            this.aggregateLicenses(artifact, "Component Specified License (mapped)", aggregatedLicenses);
            this.aggregateLicenses(artifact, "Binary Artifact - Derived Licenses", aggregatedLicenses);
            this.aggregateLicenses(artifact, "Source Artifact - Derived Licenses", aggregatedLicenses);
            this.aggregateLicenses(artifact, "Source Archive - Derived Licenses", aggregatedLicenses);
            this.aggregateLicenses(artifact, "Descriptor - Derived Licenses", aggregatedLicenses);
            this.aggregateLicenses(artifact, "Inherited License", aggregatedLicenses);
            artifact.setLicense(InventoryUtils.joinLicenses(aggregatedLicenses));
        }
    }

    private void aggregateLicenses(Artifact artifact, String key, List<String> aggregatedLicenses) {
        String derivedLicense = artifact.get(key);
        if (!StringUtils.isEmpty((String)derivedLicense)) {
            aggregatedLicenses.addAll(InventoryUtils.tokenizeLicense((String)derivedLicense, (boolean)true, (boolean)true));
        }
    }

    public boolean isEnableUseDerivedLicense() {
        return this.enableUseDerivedLicense;
    }

    public void setEnableUseDerivedLicense(boolean enableUseDerivedLicense) {
        this.enableUseDerivedLicense = enableUseDerivedLicense;
    }

    public boolean isEnableInherit() {
        return this.enableInherit;
    }

    public void setEnableInherit(boolean enableInherit) {
        this.enableInherit = enableInherit;
    }

    public boolean isEnableAddComponentNameAndVersion() {
        return this.enableAddComponentNameAndVersion;
    }

    public void setEnableAddComponentNameAndVersion(boolean enableAddComponentNameAndVersion) {
        this.enableAddComponentNameAndVersion = enableAddComponentNameAndVersion;
    }

    public boolean isEnableApplyCurationData() {
        return this.enableApplyCurationData;
    }

    public void setEnableApplyCurationData(boolean enableApplyCurationData) {
        this.enableApplyCurationData = enableApplyCurationData;
    }
}

