/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.workbench;

import com.metaeffekt.artifact.analysis.utils.InventoryUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.LicenseData;

public class WorkbenchUtils
extends InventoryUtils {
    private static Set<String> collectArtifactLicenses(Inventory projectInventory, Artifact artifact, boolean includeDerivedLicenses) {
        HashSet<String> artifactLicenseSet = new HashSet<String>();
        List associatedLicenses = InventoryUtils.tokenizeLicense((String)artifact.getLicense(), (boolean)false, (boolean)false);
        List effectiveLicenses = projectInventory.getEffectiveLicenses(artifact);
        artifactLicenseSet.addAll(associatedLicenses);
        artifactLicenseSet.addAll(effectiveLicenses);
        if (associatedLicenses.isEmpty() && effectiveLicenses.isEmpty() && includeDerivedLicenses) {
            artifactLicenseSet.addAll(InventoryUtils.tokenizeLicense((String)artifact.get("Derived Licenses"), (boolean)false, (boolean)true));
            artifactLicenseSet.addAll(InventoryUtils.tokenizeLicense((String)artifact.get("Binary Artifact - Derived Licenses"), (boolean)false, (boolean)true));
            artifactLicenseSet.addAll(InventoryUtils.tokenizeLicense((String)artifact.get("Source Artifact - Derived Licenses"), (boolean)false, (boolean)true));
            artifactLicenseSet.addAll(InventoryUtils.tokenizeLicense((String)artifact.get("Source Archive - Derived Licenses"), (boolean)false, (boolean)true));
            artifactLicenseSet.addAll(InventoryUtils.tokenizeLicense((String)artifact.get("Descriptor - Derived Licenses"), (boolean)false, (boolean)true));
            artifactLicenseSet.addAll(InventoryUtils.tokenizeLicense((String)artifact.get("Package Specified License (mapped)"), (boolean)false, (boolean)true));
            artifactLicenseSet.addAll(InventoryUtils.tokenizeLicense((String)artifact.get("Component Specified License (mapped)"), (boolean)false, (boolean)true));
        }
        HashSet licenseOptions = new HashSet();
        for (String license : artifactLicenseSet) {
            if (!license.contains(" + ")) continue;
            licenseOptions.addAll(WorkbenchUtils.tokenizeLicense((String)license, (boolean)false, (boolean)false));
        }
        artifactLicenseSet.addAll(licenseOptions);
        return artifactLicenseSet;
    }

    public static void addLicenseData(Inventory projectInventory) {
        WorkbenchUtils.addLicenseData(projectInventory, false, false);
    }

    public static void addLicenseData(Inventory projectInventory, boolean failOnMissingLicenseData) {
        WorkbenchUtils.addLicenseData(projectInventory, failOnMissingLicenseData, false);
    }

    public static void addLicenseData(Inventory projectInventory, boolean failOnMissingLicenseData, boolean includeDerivedLicenses) {
        if (NORMALIZATION_META_DATA == null) {
            throw new IllegalStateException("Method addLicenseData requires TermsMetaData to be initialized.");
        }
        HashSet<String> canonicalNames = new HashSet<String>();
        HashMap<Artifact, Set<String>> artifactLicenseSetMap = new HashMap<Artifact, Set<String>>();
        for (Object artifact : projectInventory.getArtifacts()) {
            Set<String> artifactLicenseSet = WorkbenchUtils.collectArtifactLicenses(projectInventory, (Artifact)artifact, includeDerivedLicenses);
            artifactLicenseSetMap.put((Artifact)artifact, artifactLicenseSet);
            canonicalNames.addAll(artifactLicenseSet);
        }
        canonicalNames.remove("ANY");
        canonicalNames.remove("(");
        canonicalNames.remove(")");
        HashSet<String> licenseWithoutTermsMetadata = new HashSet<String>();
        for (String canonicalName : new HashSet(canonicalNames)) {
            TermsMetaData termsMetaData = NORMALIZATION_META_DATA.getTermsMetaData(canonicalName);
            if (termsMetaData == null) {
                licenseWithoutTermsMetadata.add(canonicalName);
                continue;
            }
            String representedAs = termsMetaData.getRepresentedAs();
            if (representedAs == null) continue;
            TermsMetaData representedAsTermsMetaData = NORMALIZATION_META_DATA.getTermsMetaData(representedAs);
            if (representedAsTermsMetaData != null) {
                canonicalNames.add(representedAsTermsMetaData.getCanonicalName());
                continue;
            }
            licenseWithoutTermsMetadata.add(representedAs);
        }
        if (!licenseWithoutTermsMetadata.isEmpty() && failOnMissingLicenseData) {
            throw new IllegalStateException("No terms metadata resolved for canonical names " + licenseWithoutTermsMetadata + ".");
        }
        WorkbenchUtils.insertLicenseDataForCanonicalNames(canonicalNames, (Inventory)projectInventory);
        Set assetIds = WorkbenchUtils.collectAssetIdsFromAssetMetaData((Inventory)projectInventory);
        assetIds.addAll(WorkbenchUtils.collectAssetIdsFromArtifacts((Inventory)projectInventory));
        for (LicenseData licenseData : projectInventory.getLicenseData()) {
            String canonicalName = licenseData.get(LicenseData.Attribute.CANONICAL_NAME);
            boolean isPackage = false;
            boolean isWebModule = false;
            for (Artifact artifact : projectInventory.getArtifacts()) {
                String type = artifact.get("Type");
                Set licenses = (Set)artifactLicenseSetMap.get(artifact);
                if (!licenses.contains(canonicalName)) continue;
                if (type != null && !licenses.isEmpty() && licenses.contains(canonicalName)) {
                    isPackage |= type.contains("package");
                    isPackage |= type.contains("package");
                    isWebModule |= type.contains("nodejs-module");
                    isWebModule |= type.contains("nodejs-module");
                }
                String artifactAssetId = InventoryUtils.deriveAssetIdFromArtifact((Artifact)artifact);
                for (String assetId : assetIds) {
                    String artifactInAsset = artifact.get(assetId);
                    if (StringUtils.hasText((String)artifactInAsset)) {
                        licenseData.set(assetId, artifactInAsset);
                    }
                    if (artifactAssetId == null || !artifactAssetId.equals(assetId)) continue;
                    licenseData.set(artifactAssetId, "x");
                }
            }
            licenseData.set("Type Package", isPackage ? "x" : "");
            licenseData.set("Type Web Module", isWebModule ? "x" : "");
            licenseData.set("Type Artifact", isPackage || isWebModule ? "" : "x");
        }
    }
}

