/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.workbench.executors;

import com.metaeffekt.artifact.analysis.flow.grpc.worker.TaskType;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import java.io.File;

public class AssetIdentification {
    private String projectName;
    private String assetGroupName;
    private String assetGroupVersion;
    private String assetName;
    private String assetVersion;
    private String assetPartName;
    private String assetPartVersion;

    public AssetIdentification(File inventoryFile) {
        File parentFile = inventoryFile.getParentFile();
        File grantParentFile = parentFile.getParentFile();
        this.setAssetGroupName(grantParentFile.getName());
        this.setAssetGroupVersion(parentFile.getName());
        this.setProjectName(grantParentFile.getParentFile().getName());
        String assetRef = inventoryFile.getName();
        assetRef = assetRef.substring(0, assetRef.lastIndexOf("_"));
        String[] assetRefSplit = assetRef.split("_");
        this.setAssetName(assetRefSplit[0]);
        if (assetRefSplit.length > 1) {
            this.setAssetVersion(assetRefSplit[1]);
        }
        if (assetRefSplit.length > 2) {
            this.setAssetPartName(assetRefSplit[2]);
        }
        if (assetRefSplit.length > 3) {
            this.setAssetPartName(assetRefSplit[3]);
        }
    }

    public String deriveAssetId(TaskType type) {
        String assetRef = this.getAssetRef();
        switch (type) {
            case PORTFOLIO_REPORT: 
            case OVERALL_REPORT: {
                return "AID-" + this.projectName + "-" + this.assetGroupName;
            }
            case PROJECT_REPORT: {
                return "AID-" + this.projectName + "-" + this.assetGroupName + ":" + this.assetGroupVersion;
            }
        }
        return "AID-" + this.projectName + "-" + this.assetGroupName + ":" + this.assetGroupVersion + "-" + assetRef;
    }

    public String getAssetRef() {
        String assetRef = this.assetName;
        if (StringUtils.hasText((String)this.assetVersion)) {
            assetRef = assetRef + ":" + this.assetVersion;
        }
        if (StringUtils.hasText((String)this.assetPartName)) {
            assetRef = assetRef + ":" + this.assetPartName;
        }
        if (StringUtils.hasText((String)this.assetPartVersion)) {
            assetRef = assetRef + ":" + this.assetPartVersion;
        }
        return assetRef;
    }

    public String getAssetGroupRef() {
        String assetGroupRef = this.assetGroupName;
        if (StringUtils.hasText((String)this.assetGroupVersion)) {
            assetGroupRef = assetGroupRef + ":" + this.assetGroupVersion;
        }
        return assetGroupRef;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getAssetGroupName() {
        return this.assetGroupName;
    }

    public String getAssetGroupVersion() {
        return this.assetGroupVersion;
    }

    public String getAssetName() {
        return this.assetName;
    }

    public String getAssetVersion() {
        return this.assetVersion;
    }

    public String getAssetPartName() {
        return this.assetPartName;
    }

    public String getAssetPartVersion() {
        return this.assetPartVersion;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setAssetGroupName(String assetGroupName) {
        this.assetGroupName = assetGroupName;
    }

    public void setAssetGroupVersion(String assetGroupVersion) {
        this.assetGroupVersion = assetGroupVersion;
    }

    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }

    public void setAssetVersion(String assetVersion) {
        this.assetVersion = assetVersion;
    }

    public void setAssetPartName(String assetPartName) {
        this.assetPartName = assetPartName;
    }

    public void setAssetPartVersion(String assetPartVersion) {
        this.assetPartVersion = assetPartVersion;
    }
}

