/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.workbench.executors;

import com.metaeffekt.artifact.analysis.flow.AttachReportFlow;
import com.metaeffekt.artifact.analysis.flow.FormatInventoryFlow;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.FileInputOutputParams;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.FileLocation;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.Task;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.TaskType;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.workbench.ProjectInventoryFilter;
import com.metaeffekt.artifact.analysis.workbench.executors.TaskExecutor;
import com.metaeffekt.resource.InventoryResource;
import java.io.File;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportTaskExecutor
implements TaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(ReportTaskExecutor.class);
    private final AttachReportFlow attachReportFlow = new AttachReportFlow();
    private final FormatInventoryFlow formatInventoryFlow = new FormatInventoryFlow();
    private final InventoryResource referenceInventoryResource;

    public ReportTaskExecutor(InventoryResource referenceInventoryResource) {
        this.referenceInventoryResource = referenceInventoryResource;
    }

    @Override
    public boolean execute(Task task) throws Exception {
        if (TaskType.REPORT.equals((Object)task.getType())) {
            FileInputOutputParams scanInventory = task.getInputOutput();
            FileLocation inFile = scanInventory.getInFile();
            FileLocation outFile = scanInventory.getOutFile();
            File inputInventoryFile = new File(inFile.getBaseDir(), inFile.getRelativePath());
            File outputInventoryFile = new File(outFile.getBaseDir(), outFile.getRelativePath());
            if (inputInventoryFile.exists()) {
                this.logExecutionStarted(log, task);
                InventoryResource inventoryResource = InventoryResource.fromFile((File)inputInventoryFile);
                Inventory referenceInventory = this.referenceInventoryResource.reloadInventory();
                inventoryResource.getInventory().getLicenseData().clear();
                ProjectInventoryFilter projectInventoryFilter = new ProjectInventoryFilter();
                projectInventoryFilter.setEnableApplyCurationData(true);
                projectInventoryFilter.process(inventoryResource.getInventory(), referenceInventory);
                this.attachReportFlow.attachReport(inventoryResource);
                this.formatInventoryFlow.filterAndFormat(inventoryResource);
                FileUtils.forceMkdirParent((File)outputInventoryFile);
                inventoryResource.sync(outputInventoryFile);
                this.logExecutionCompleted(log, task);
                return true;
            }
        }
        return false;
    }
}

