/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.workbench.executors;

import com.metaeffekt.artifact.analysis.flow.InventoryResult;
import com.metaeffekt.artifact.analysis.flow.ResolverFlow;
import com.metaeffekt.artifact.analysis.flow.ResolverFlowParam;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.FileInputOutputParams;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.FileLocation;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.Task;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.TaskType;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.workbench.executors.TaskExecutor;
import com.metaeffekt.resource.InventoryResource;
import java.io.File;

public class ResolveTaskExecutor
implements TaskExecutor {
    private final ResolverFlow resolverFlow = new ResolverFlow();
    private final ResolverFlowParam resolverFlowParamTemplate;

    public ResolveTaskExecutor(ResolverFlowParam resolverFlowParamTemplate) {
        this.resolverFlowParamTemplate = resolverFlowParamTemplate;
    }

    @Override
    public boolean execute(Task task) throws Exception {
        if (TaskType.RESOLVE.equals((Object)task.getType())) {
            FileInputOutputParams resolveInventory = task.getInputOutput();
            FileLocation inFile = resolveInventory.getInFile();
            FileLocation outFile = resolveInventory.getOutFile();
            File inputInventoryFile = new File(inFile.getBaseDir(), inFile.getRelativePath());
            File outputInventoryFile = new File(outFile.getBaseDir(), outFile.getRelativePath());
            if (inputInventoryFile.exists()) {
                ResolverFlowParam resolverFlowParam = new ResolverFlowParam(this.resolverFlowParamTemplate);
                resolverFlowParam.withInventory(InventoryResource.fromFile((File)inputInventoryFile));
                InventoryResult process = this.resolverFlow.process(resolverFlowParam);
                if (process != null) {
                    FileUtils.forceMkdirParent((File)outputInventoryFile);
                    process.getInventoryResource().sync(outputInventoryFile);
                    return true;
                }
            }
        }
        return false;
    }
}

