/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.metaeffekt.artifact.resolver.alpine.AlpinePackageResolverConfig;
import org.metaeffekt.artifact.resolver.deb.DebArtifactResolverConfig;
import org.metaeffekt.artifact.resolver.generic.IndexConfig;
import org.metaeffekt.artifact.resolver.manager.execenv.EnvironmentManagerConfig;
import org.metaeffekt.artifact.resolver.maven.MavenArtifactResolverConfig;
import org.metaeffekt.artifact.resolver.rpm.index.RpmIndexConfig;
import org.metaeffekt.core.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactResolverConfig {
    private static final Logger log = LoggerFactory.getLogger(ArtifactResolverConfig.class);
    private MavenArtifactResolverConfig mavenConfig;
    private IndexConfig indexConfig;
    private EnvironmentManagerConfig environmentManagerConfig;
    private AlpinePackageResolverConfig alpinePackageResolverConfig;
    private RpmIndexConfig rpmIndexConfig;
    private DebArtifactResolverConfig debArtifactResolverConfig;

    public static ArtifactResolverConfig parseFromYaml(File yamlFile) throws IOException {
        log.trace("Reading config file content from [{}] to string.", (Object)yamlFile);
        String content = FileUtils.readFileToString((File)yamlFile, (String)"UTF-8");
        if (StringUtils.isEmpty((CharSequence)content)) {
            return new ArtifactResolverConfig();
        }
        YAMLFactory factory = new YAMLFactory();
        ObjectMapper mapper = new ObjectMapper((JsonFactory)factory);
        log.trace("Creating ArtifactResolverConfig from content of file [{}].", (Object)yamlFile);
        return (ArtifactResolverConfig)mapper.readValue(content, ArtifactResolverConfig.class);
    }

    public MavenArtifactResolverConfig getMavenConfig() {
        return this.mavenConfig;
    }

    public IndexConfig getIndexConfig() {
        return this.indexConfig;
    }

    public EnvironmentManagerConfig getEnvironmentManagerConfig() {
        return this.environmentManagerConfig;
    }

    public AlpinePackageResolverConfig getAlpinePackageResolverConfig() {
        return this.alpinePackageResolverConfig;
    }

    public RpmIndexConfig getRpmIndexConfig() {
        return this.rpmIndexConfig;
    }

    public DebArtifactResolverConfig getDebArtifactResolverConfig() {
        return this.debArtifactResolverConfig;
    }

    public void setMavenConfig(MavenArtifactResolverConfig mavenConfig) {
        this.mavenConfig = mavenConfig;
    }

    public void setIndexConfig(IndexConfig indexConfig) {
        this.indexConfig = indexConfig;
    }

    public void setEnvironmentManagerConfig(EnvironmentManagerConfig environmentManagerConfig) {
        this.environmentManagerConfig = environmentManagerConfig;
    }

    public void setAlpinePackageResolverConfig(AlpinePackageResolverConfig alpinePackageResolverConfig) {
        this.alpinePackageResolverConfig = alpinePackageResolverConfig;
    }

    public void setRpmIndexConfig(RpmIndexConfig rpmIndexConfig) {
        this.rpmIndexConfig = rpmIndexConfig;
    }

    public void setDebArtifactResolverConfig(DebArtifactResolverConfig debArtifactResolverConfig) {
        this.debArtifactResolverConfig = debArtifactResolverConfig;
    }
}

