/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.metaeffekt.artifact.resolver.ArtifactResolver;
import org.metaeffekt.artifact.resolver.ArtifactResolverConfig;
import org.metaeffekt.artifact.resolver.alpine.AlpinePackageResolver;
import org.metaeffekt.artifact.resolver.cargo.CargoArtifactResolver;
import org.metaeffekt.artifact.resolver.deb.DebArtifactResolver;
import org.metaeffekt.artifact.resolver.download.WebAccess;
import org.metaeffekt.artifact.resolver.generic.ArtifactIndex;
import org.metaeffekt.artifact.resolver.generic.IndexConfig;
import org.metaeffekt.artifact.resolver.manager.DownloadEnvironmentManager;
import org.metaeffekt.artifact.resolver.maven.MavenArtifactResolver;
import org.metaeffekt.artifact.resolver.model.ArtifactPartResolver;
import org.metaeffekt.artifact.resolver.model.ArtifactPartType;
import org.metaeffekt.artifact.resolver.model.DownloadLocation;
import org.metaeffekt.artifact.resolver.model.ResolvedArtifactPart;
import org.metaeffekt.artifact.resolver.npm.NpmArtifactResolver;
import org.metaeffekt.artifact.resolver.pypi.PyPIArtifactResolver;
import org.metaeffekt.artifact.resolver.rpm.RpmArtifactResolver;
import org.metaeffekt.artifact.resolver.url.UrlArtifactResolver;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactResolverManager {
    private static final Logger log = LoggerFactory.getLogger(ArtifactResolverManager.class);
    private final DownloadLocation downloadLocation;
    private final WebAccess webAccess;
    private final List<ArtifactResolver> artifactResolverList = new ArrayList<ArtifactResolver>();
    private ArtifactResolverConfig artifactResolverConfig;
    private final DownloadEnvironmentManager environmentManager;

    public ArtifactResolverManager(@NonNull DownloadLocation downloadLocation, @NonNull WebAccess webAccess, @NonNull ArtifactResolverConfig resolverConfig) {
        if (downloadLocation == null) {
            throw new NullPointerException("downloadLocation is marked non-null but is null");
        }
        if (webAccess == null) {
            throw new NullPointerException("webAccess is marked non-null but is null");
        }
        if (resolverConfig == null) {
            throw new NullPointerException("resolverConfig is marked non-null but is null");
        }
        this.downloadLocation = downloadLocation;
        this.webAccess = webAccess;
        this.artifactResolverConfig = resolverConfig;
        IndexConfig indexConfig = this.artifactResolverConfig.getIndexConfig();
        ArtifactIndex artifactIndex = new ArtifactIndex(indexConfig);
        this.artifactResolverList.add(new MavenArtifactResolver(downloadLocation, webAccess, artifactIndex, this.artifactResolverConfig.getMavenConfig()));
        this.artifactResolverList.add(new NpmArtifactResolver(downloadLocation, webAccess));
        this.artifactResolverList.add(new UrlArtifactResolver(downloadLocation, webAccess));
        this.artifactResolverList.add(new PyPIArtifactResolver(downloadLocation));
        this.artifactResolverList.add(new CargoArtifactResolver(downloadLocation, webAccess));
        if (this.artifactResolverConfig.getRpmIndexConfig() != null) {
            this.artifactResolverList.add(new RpmArtifactResolver(downloadLocation, webAccess, this.artifactResolverConfig.getRpmIndexConfig()));
        }
        if (this.artifactResolverConfig.getDebArtifactResolverConfig() != null) {
            this.artifactResolverList.add(new DebArtifactResolver(downloadLocation, webAccess, this.artifactResolverConfig.getDebArtifactResolverConfig()));
        }
        if (resolverConfig.getEnvironmentManagerConfig() != null && resolverConfig.getEnvironmentManagerConfig().isEnableEnvironmentManager()) {
            this.environmentManager = DownloadEnvironmentManager.createIfAvailable(resolverConfig.getEnvironmentManagerConfig());
            if (this.environmentManager != null) {
                this.artifactResolverList.add(new AlpinePackageResolver(downloadLocation, webAccess, this.environmentManager, resolverConfig));
            }
        } else {
            this.environmentManager = null;
        }
    }

    public ResolvedArtifactPart resolveBinaryArtifact(Artifact artifact) {
        return this.getResolvedArtifactPart(artifact, ArtifactPartType.BINARY_ARTIFACT);
    }

    public ResolvedArtifactPart resolveSourceArtifact(Artifact artifact) {
        return this.getResolvedArtifactPart(artifact, ArtifactPartType.SOURCE_ARTIFACT);
    }

    public ResolvedArtifactPart resolveSourceArchive(Artifact artifact) {
        return this.getResolvedArtifactPart(artifact, ArtifactPartType.SOURCE_ARCHIVE);
    }

    public ResolvedArtifactPart resolveDescriptor(Artifact artifact) {
        return this.getResolvedArtifactPart(artifact, ArtifactPartType.DESCRIPTOR);
    }

    private ResolvedArtifactPart getResolvedArtifactPart(@NonNull Artifact artifact, @NonNull ArtifactPartType artifactPartType) {
        if (artifact == null) {
            throw new NullPointerException("artifact is marked non-null but is null");
        }
        if (artifactPartType == null) {
            throw new NullPointerException("artifactPartType is marked non-null but is null");
        }
        return (ResolvedArtifactPart)this.getResolvedArtifactParts(artifact, Collections.singleton(artifactPartType)).get((Object)artifactPartType);
    }

    public SortedMap<ArtifactPartType, ResolvedArtifactPart> getResolvedArtifactParts(@NonNull Artifact artifact) {
        if (artifact == null) {
            throw new NullPointerException("artifact is marked non-null but is null");
        }
        return this.getResolvedArtifactParts(artifact, null);
    }

    public SortedMap<ArtifactPartType, ResolvedArtifactPart> getResolvedArtifactParts(@NonNull Artifact artifact, Collection<ArtifactPartType> partTypes) {
        if (artifact == null) {
            throw new NullPointerException("artifact is marked non-null but is null");
        }
        return this.processPartResolvers(this.collectArtifactPartResolvers(artifact, partTypes));
    }

    private SortedMap<ArtifactPartType, ResolvedArtifactPart> processPartResolvers(@NonNull List<ArtifactPartResolver> partResolvers) {
        if (partResolvers == null) {
            throw new NullPointerException("partResolvers is marked non-null but is null");
        }
        TreeMap<ArtifactPartType, ResolvedArtifactPart> typeToResolved = new TreeMap<ArtifactPartType, ResolvedArtifactPart>();
        for (ArtifactPartResolver partResolver : partResolvers) {
            ResolvedArtifactPart resolvedArtifactPart;
            if (typeToResolved.get((Object)partResolver.getArtifactPartType()) != null || (resolvedArtifactPart = partResolver.get()) == null) continue;
            typeToResolved.put(partResolver.getArtifactPartType(), resolvedArtifactPart);
        }
        return typeToResolved;
    }

    public void resolveAndMergeAll(@NonNull Artifact artifact) {
        if (artifact == null) {
            throw new NullPointerException("artifact is marked non-null but is null");
        }
        Artifact clone = new Artifact(artifact);
        SortedMap<ArtifactPartType, ResolvedArtifactPart> resolvedParts = this.getResolvedArtifactParts(clone, null);
        this.merge(artifact, (ResolvedArtifactPart)resolvedParts.remove((Object)ArtifactPartType.DESCRIPTOR));
        this.merge(artifact, (ResolvedArtifactPart)resolvedParts.remove((Object)ArtifactPartType.BINARY_ARTIFACT));
        this.merge(artifact, (ResolvedArtifactPart)resolvedParts.remove((Object)ArtifactPartType.SOURCE_ARTIFACT));
        this.merge(artifact, (ResolvedArtifactPart)resolvedParts.remove((Object)ArtifactPartType.SOURCE_ARCHIVE));
        for (ResolvedArtifactPart resolvedPart : resolvedParts.values()) {
            this.merge(artifact, resolvedPart);
        }
    }

    private void merge(@NonNull Artifact artifact, ResolvedArtifactPart resolveArtifactPart) {
        Artifact enrichedArtifact;
        if (artifact == null) {
            throw new NullPointerException("artifact is marked non-null but is null");
        }
        if (resolveArtifactPart != null && (enrichedArtifact = resolveArtifactPart.getEnrichedArtifact()) != null) {
            artifact.merge(enrichedArtifact);
        }
    }

    private List<ArtifactPartResolver> collectArtifactPartResolvers(@NonNull Artifact artifact, Collection<ArtifactPartType> partTypes) {
        if (artifact == null) {
            throw new NullPointerException("artifact is marked non-null but is null");
        }
        EnumSet<ArtifactPartType> partTypeSet = partTypes == null ? null : EnumSet.copyOf(partTypes);
        return this.artifactResolverList.stream().map(artifactResolver -> artifactResolver.collectResolvers(artifact)).flatMap(resolvers -> resolvers.getArtifactPartResolvers().stream()).filter(partResolver -> partTypeSet == null || partTypeSet.contains((Object)partResolver.getArtifactPartType())).collect(Collectors.toList());
    }

    public boolean isEnvironmentEnabled() {
        return this.environmentManager != null;
    }
}

