/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.alpine;

import lombok.NonNull;
import org.metaeffekt.artifact.resolver.alpine.AlpineEnvironment;
import org.metaeffekt.artifact.resolver.download.ProxyConfig;
import org.metaeffekt.artifact.resolver.manager.execenv.EnvironmentParameters;

public class AlpineEnvironmentParameters
extends EnvironmentParameters<AlpineEnvironment> {
    @NonNull
    private final String registryPrefix;
    @NonNull
    private final String imageBaseName = "alpine";
    @NonNull
    private final String imageVersion = "latest";
    private final ProxyConfig proxyConfig;
    @NonNull
    private final String alpineSourcesTag;

    @Override
    public Class<AlpineEnvironment> getEnvironmentClass() {
        return AlpineEnvironment.class;
    }

    public AlpineEnvironmentParameters(ProxyConfig proxyConfig, @NonNull String alpineSourcesTag) {
        this.registryPrefix = this.defaultRegistryPrefix;
        this.imageBaseName = "alpine";
        this.imageVersion = "latest";
        if (alpineSourcesTag == null) {
            throw new NullPointerException("alpineSourcesTag is marked non-null but is null");
        }
        this.proxyConfig = proxyConfig;
        this.alpineSourcesTag = alpineSourcesTag;
    }

    @Override
    @NonNull
    public String getRegistryPrefix() {
        return this.registryPrefix;
    }

    @Override
    @NonNull
    public String getImageBaseName() {
        return this.imageBaseName;
    }

    @Override
    @NonNull
    public String getImageVersion() {
        return this.imageVersion;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    @NonNull
    public String getAlpineSourcesTag() {
        return this.alpineSourcesTag;
    }

    @Override
    public String toString() {
        return "AlpineEnvironmentParameters(registryPrefix=" + this.getRegistryPrefix() + ", imageBaseName=" + this.getImageBaseName() + ", imageVersion=" + this.getImageVersion() + ", proxyConfig=" + this.getProxyConfig() + ", alpineSourcesTag=" + this.getAlpineSourcesTag() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlpineEnvironmentParameters)) {
            return false;
        }
        AlpineEnvironmentParameters other = (AlpineEnvironmentParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$registryPrefix = this.getRegistryPrefix();
        String other$registryPrefix = other.getRegistryPrefix();
        if (this$registryPrefix == null ? other$registryPrefix != null : !this$registryPrefix.equals(other$registryPrefix)) {
            return false;
        }
        String this$imageBaseName = this.getImageBaseName();
        String other$imageBaseName = other.getImageBaseName();
        if (this$imageBaseName == null ? other$imageBaseName != null : !this$imageBaseName.equals(other$imageBaseName)) {
            return false;
        }
        String this$imageVersion = this.getImageVersion();
        String other$imageVersion = other.getImageVersion();
        if (this$imageVersion == null ? other$imageVersion != null : !this$imageVersion.equals(other$imageVersion)) {
            return false;
        }
        ProxyConfig this$proxyConfig = this.getProxyConfig();
        ProxyConfig other$proxyConfig = other.getProxyConfig();
        if (this$proxyConfig == null ? other$proxyConfig != null : !this$proxyConfig.equals(other$proxyConfig)) {
            return false;
        }
        String this$alpineSourcesTag = this.getAlpineSourcesTag();
        String other$alpineSourcesTag = other.getAlpineSourcesTag();
        return !(this$alpineSourcesTag == null ? other$alpineSourcesTag != null : !this$alpineSourcesTag.equals(other$alpineSourcesTag));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AlpineEnvironmentParameters;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $registryPrefix = this.getRegistryPrefix();
        result = result * 59 + ($registryPrefix == null ? 43 : $registryPrefix.hashCode());
        String $imageBaseName = this.getImageBaseName();
        result = result * 59 + ($imageBaseName == null ? 43 : $imageBaseName.hashCode());
        String $imageVersion = this.getImageVersion();
        result = result * 59 + ($imageVersion == null ? 43 : $imageVersion.hashCode());
        ProxyConfig $proxyConfig = this.getProxyConfig();
        result = result * 59 + ($proxyConfig == null ? 43 : $proxyConfig.hashCode());
        String $alpineSourcesTag = this.getAlpineSourcesTag();
        result = result * 59 + ($alpineSourcesTag == null ? 43 : $alpineSourcesTag.hashCode());
        return result;
    }
}

