/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.alpine;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.metaeffekt.artifact.resolver.generic.FileLocation;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlpinePackageReference {
    private static final Logger LOG = LoggerFactory.getLogger(AlpinePackageReference.class);
    private static final Pattern alpineIssuePattern = Pattern.compile("\\s*Alpine\\s*Linux");
    private static final Pattern alpineVersionPattern = Pattern.compile("[^()]+(?=\\s*\\)\\s*$)");
    private String pkgname = null;
    private String pkgver = null;
    private String pkgrel = null;
    private String alpineVersion = null;

    public AlpinePackageReference(Artifact artifact) {
        int lastR;
        String pkgname;
        if (!"package".equals(artifact.get("Type"))) {
            LOG.trace("Reference initialization rejects artifact [{}] since attr [{}] is expected to be 'package'.", (Object)artifact, (Object)"Type");
            return;
        }
        String issueText = artifact.get("Issue");
        if (issueText == null) {
            LOG.trace("Reference initialization rejects artifact [{}] due to missing attribute [{}].", (Object)artifact, (Object)"Issue");
            return;
        }
        if (!alpineIssuePattern.matcher(issueText).find()) {
            LOG.warn("Issue of artifact [{}] did not look contain [{}]. Trying anyway.", (Object)artifact, (Object)alpineIssuePattern.pattern());
        }
        String rawVersion = artifact.getVersion();
        String id = artifact.getId();
        if (id.endsWith(rawVersion)) {
            pkgname = id.substring(0, id.length() - rawVersion.length() - 1);
            lastR = rawVersion.lastIndexOf("r");
            if (lastR == -1) {
                LOG.error("Artifact id of [{}] was not formatted with release number in version.", (Object)artifact);
            }
        } else {
            LOG.error("Artifact id of [{}] did not end with version as this method expects. Has the format changed?", (Object)artifact);
            return;
        }
        String pkgver = rawVersion.substring(0, lastR - 1);
        String pkgrel = rawVersion.substring(lastR + 1);
        Matcher alpineVersionMatcher = alpineVersionPattern.matcher(issueText);
        if (!alpineVersionMatcher.find()) {
            LOG.error("Failed to get alpine version for (supposed alpine package) artifact [{}].", (Object)artifact);
            return;
        }
        String alpineVersion = alpineVersionMatcher.toMatchResult().group();
        this.pkgname = pkgname;
        this.pkgver = pkgver;
        this.pkgrel = pkgrel;
        this.alpineVersion = alpineVersion;
    }

    public FileLocation deriveFileLocation() {
        FileLocation fileLocation = new FileLocation();
        fileLocation.setEcosystem("alpine");
        String filenameNoExtension = this.getPkgname() + "-" + this.getPkgver() + "-" + this.getPkgrel();
        String filename = filenameNoExtension + ".src.tar.gz";
        fileLocation.setFilename(filename);
        fileLocation.setDispatchName(this.getPkgname());
        fileLocation.setResourceQualifier("alpine-" + this.getAlpineVersion() + "-" + filenameNoExtension);
        if (!fileLocation.isValid()) {
            throw new IllegalStateException("File location invalid: " + fileLocation);
        }
        return fileLocation;
    }

    public String deriveMarkerFileName(String modifier) {
        return String.format("%s-%s-%s-%s.marker", this.pkgname, this.pkgver, this.pkgrel, modifier);
    }

    public String toString() {
        return "AlpinePackageReference{pkgname='" + this.pkgname + '\'' + ", pkgver='" + this.pkgver + '\'' + ", pkgrel='" + this.pkgrel + '\'' + ", alpineVersion='" + this.alpineVersion + '\'' + '}';
    }

    public boolean isValid() {
        return StringUtils.isNotBlank((CharSequence)this.pkgname) && StringUtils.isNotBlank((CharSequence)this.pkgver) && StringUtils.isNotBlank((CharSequence)this.pkgrel) && StringUtils.isNotBlank((CharSequence)this.alpineVersion);
    }

    public AlpinePackageReference(String pkgname, String pkgver, String pkgrel, String alpineVersion) {
        this.pkgname = pkgname;
        this.pkgver = pkgver;
        this.pkgrel = pkgrel;
        this.alpineVersion = alpineVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlpinePackageReference)) {
            return false;
        }
        AlpinePackageReference other = (AlpinePackageReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pkgname = this.getPkgname();
        String other$pkgname = other.getPkgname();
        if (this$pkgname == null ? other$pkgname != null : !this$pkgname.equals(other$pkgname)) {
            return false;
        }
        String this$pkgver = this.getPkgver();
        String other$pkgver = other.getPkgver();
        if (this$pkgver == null ? other$pkgver != null : !this$pkgver.equals(other$pkgver)) {
            return false;
        }
        String this$pkgrel = this.getPkgrel();
        String other$pkgrel = other.getPkgrel();
        if (this$pkgrel == null ? other$pkgrel != null : !this$pkgrel.equals(other$pkgrel)) {
            return false;
        }
        String this$alpineVersion = this.getAlpineVersion();
        String other$alpineVersion = other.getAlpineVersion();
        return !(this$alpineVersion == null ? other$alpineVersion != null : !this$alpineVersion.equals(other$alpineVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlpinePackageReference;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pkgname = this.getPkgname();
        result = result * 59 + ($pkgname == null ? 43 : $pkgname.hashCode());
        String $pkgver = this.getPkgver();
        result = result * 59 + ($pkgver == null ? 43 : $pkgver.hashCode());
        String $pkgrel = this.getPkgrel();
        result = result * 59 + ($pkgrel == null ? 43 : $pkgrel.hashCode());
        String $alpineVersion = this.getAlpineVersion();
        result = result * 59 + ($alpineVersion == null ? 43 : $alpineVersion.hashCode());
        return result;
    }

    public String getPkgname() {
        return this.pkgname;
    }

    public String getPkgver() {
        return this.pkgver;
    }

    public String getPkgrel() {
        return this.pkgrel;
    }

    public String getAlpineVersion() {
        return this.alpineVersion;
    }
}

