/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.alpine;

import java.util.ArrayList;
import lombok.NonNull;
import org.metaeffekt.artifact.resolver.ArtifactResolver;
import org.metaeffekt.artifact.resolver.ArtifactResolverConfig;
import org.metaeffekt.artifact.resolver.alpine.AlpineDownloaderAdapter;
import org.metaeffekt.artifact.resolver.alpine.AlpinePackageReference;
import org.metaeffekt.artifact.resolver.download.WebAccess;
import org.metaeffekt.artifact.resolver.manager.DownloadEnvironmentManager;
import org.metaeffekt.artifact.resolver.model.ArtifactPartResolver;
import org.metaeffekt.artifact.resolver.model.ArtifactPartResolvers;
import org.metaeffekt.artifact.resolver.model.DownloadLocation;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlpinePackageResolver
implements ArtifactResolver {
    private static final Logger log = LoggerFactory.getLogger(AlpinePackageResolver.class);
    private final DownloadEnvironmentManager environmentManager;
    private final AlpineDownloaderAdapter alpineAdapter;

    public AlpinePackageResolver(@NonNull DownloadLocation downloadLocation, @NonNull WebAccess webAccess, @NonNull DownloadEnvironmentManager environmentManager, @NonNull ArtifactResolverConfig resolverConfig) {
        if (downloadLocation == null) {
            throw new NullPointerException("downloadLocation is marked non-null but is null");
        }
        if (webAccess == null) {
            throw new NullPointerException("webAccess is marked non-null but is null");
        }
        if (environmentManager == null) {
            throw new NullPointerException("environmentManager is marked non-null but is null");
        }
        if (resolverConfig == null) {
            throw new NullPointerException("resolverConfig is marked non-null but is null");
        }
        this.environmentManager = environmentManager;
        this.alpineAdapter = new AlpineDownloaderAdapter(downloadLocation, webAccess, environmentManager, resolverConfig);
    }

    @Override
    public ArtifactPartResolvers collectResolvers(@NonNull Artifact artifact) {
        ArtifactPartResolver part;
        if (artifact == null) {
            throw new NullPointerException("artifact is marked non-null but is null");
        }
        AlpinePackageReference reference = new AlpinePackageReference(artifact);
        ArrayList<ArtifactPartResolver> parts = new ArrayList<ArtifactPartResolver>();
        if (reference.isValid() && (part = this.alpineAdapter.downloadSourceArchive(artifact, reference)) != null) {
            parts.add(part);
        }
        return new ArtifactPartResolvers(parts);
    }
}

