/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.deb;

import com.github.packageurl.PackageURL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.metaeffekt.artifact.resolver.generic.FileLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebArtifactReference {
    private static final Logger log = LoggerFactory.getLogger(DebArtifactReference.class);
    private String name = null;
    private String version = null;
    private String architecture = null;
    private DebNamespace namespace = null;

    public DebArtifactReference(PackageURL purl) {
        if (!"deb".equals(purl.getType())) {
            log.error("Purl [{}] isn't a deb purl.", (Object)purl);
            return;
        }
        String name = purl.getName();
        String version = purl.getVersion();
        if (name != null && name.contains(" ")) {
            log.warn("Given purl [{}] contains space in name. This is not allowed. Aborting resolution.", (Object)purl);
            return;
        }
        if (version != null && version.contains(" ")) {
            log.warn("Given purl [{}] contains space in version. This is not allowed. Aborting resolution.", (Object)purl);
            return;
        }
        Map qualifiers = purl.getQualifiers() == null ? new HashMap() : purl.getQualifiers();
        String architecture = (String)qualifiers.get("arch");
        DebNamespace namespace = null;
        try {
            namespace = purl.getNamespace() == null ? null : DebNamespace.valueOf(purl.getNamespace().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            log.trace("Rejected purl [{}] of incompatible namespace.", (Object)purl);
        }
        if (name != null && version != null && namespace != null) {
            this.name = name;
            this.version = version;
            this.architecture = architecture;
            this.namespace = namespace;
        } else {
            log.trace("One of name, version, namespace was null: Invalidating due to params [{}], [{}], [{}].", new Object[]{name, version, namespace});
        }
    }

    public DebArtifactReference(String name, String version, String architecture, DebNamespace namespace) {
        if (name != null && version != null && namespace != null) {
            this.name = name;
            this.version = version;
            this.architecture = architecture;
            this.namespace = namespace;
        }
    }

    public FileLocation deriveFileLocation(String filename) {
        FileLocation fileLocation = new FileLocation();
        fileLocation.setEcosystem("deb-" + this.getNamespace().toString().toLowerCase(Locale.ENGLISH));
        fileLocation.setFilename(filename);
        fileLocation.setDispatchName(this.getName());
        fileLocation.setResourceQualifier(this.getNamespace().toString() + "-" + this.getName() + "_" + this.getVersion() + "_" + this.getArchitecture());
        if (!fileLocation.isValid()) {
            throw new IllegalStateException("File location invalid: " + fileLocation);
        }
        return fileLocation;
    }

    public boolean isValid() {
        return StringUtils.isNotBlank((CharSequence)this.name) && StringUtils.isNotBlank((CharSequence)this.version) && StringUtils.isNotBlank((CharSequence)this.architecture) && this.namespace != null;
    }

    public String toString() {
        return "DebArtifactReference{name='" + this.name + '\'' + ", version='" + this.version + '\'' + ", architecture='" + this.architecture + '\'' + ", namespace=" + (Object)((Object)this.namespace) + '}';
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public DebNamespace getNamespace() {
        return this.namespace;
    }

    public static enum DebNamespace {
        DEBIAN,
        UBUNTU;

    }
}

