/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.deb;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.metaeffekt.artifact.resolver.ArtifactResolver;
import org.metaeffekt.artifact.resolver.ResolverResult;
import org.metaeffekt.artifact.resolver.deb.DebArtifactReference;
import org.metaeffekt.artifact.resolver.deb.DebArtifactResolverConfig;
import org.metaeffekt.artifact.resolver.deb.index.packages.DebPackagesIndex;
import org.metaeffekt.artifact.resolver.deb.index.packages.parser.DebianPackagesEntry;
import org.metaeffekt.artifact.resolver.deb.index.packages.parser.PackagesEntryParsingException;
import org.metaeffekt.artifact.resolver.deb.ubuntu.UbuntuLaunchpadAdapter;
import org.metaeffekt.artifact.resolver.deb.ubuntu.UbuntuPoolAdapter;
import org.metaeffekt.artifact.resolver.download.WebAccess;
import org.metaeffekt.artifact.resolver.generic.utils.MarkerUtils;
import org.metaeffekt.artifact.resolver.model.ArtifactPartResolver;
import org.metaeffekt.artifact.resolver.model.ArtifactPartResolvers;
import org.metaeffekt.artifact.resolver.model.ArtifactPartType;
import org.metaeffekt.artifact.resolver.model.DownloadLocation;
import org.metaeffekt.artifact.resolver.model.ResolvedArtifactPart;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebArtifactResolver
implements ArtifactResolver {
    private static final Logger log = LoggerFactory.getLogger(DebArtifactResolver.class);
    private static final Pattern controlFilePattern = Pattern.compile("[./]*control$");
    private final UbuntuLaunchpadAdapter ubuntuLaunchpadAdapter;
    private final UbuntuPoolAdapter ubuntuPoolAdapter;
    private final DebPackagesIndex ubuntuIndex;
    private final DebArtifactResolverConfig resolverConfig;

    public DebArtifactResolver(DownloadLocation downloadLocation, WebAccess webAccess, DebArtifactResolverConfig resolverConfig) {
        this.ubuntuLaunchpadAdapter = new UbuntuLaunchpadAdapter(downloadLocation, webAccess);
        this.ubuntuIndex = new DebPackagesIndex(downloadLocation, webAccess, resolverConfig.getUbuntuIndexConfig());
        this.resolverConfig = resolverConfig;
        this.ubuntuPoolAdapter = new UbuntuPoolAdapter(downloadLocation, webAccess, resolverConfig.getUbuntuPoolAdapterConfig());
    }

    @Override
    public ArtifactPartResolvers collectResolvers(Artifact artifact) {
        HashSet<ArtifactPartResolver> parts = new HashSet<ArtifactPartResolver>();
        try {
            parts.addAll(this.getArtifactResolverPartsForPurl(artifact));
        }
        catch (Exception e) {
            log.warn("Unexpected exception while trying to get resolver for [{}]: [{}].", (Object)artifact, (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        return new ArtifactPartResolvers(parts);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DebArtifactReference getSourceRefFromDebFile(File debFile, DebArtifactReference binaryRef, String diagnostic) {
        try (InputStream inputStream = Files.newInputStream(debFile.toPath(), new OpenOption[0]);
             ArArchiveInputStream arInputStream = new ArArchiveInputStream(inputStream);){
            ArArchiveEntry arEntry;
            while ((arEntry = arInputStream.getNextEntry()) != null) {
                Throwable throwable;
                TarArchiveInputStream innerTarInputStream;
                block57: {
                    GZIPInputStream decompInputStream;
                    if (arEntry.getName().equals("control.tar.gz")) {
                        decompInputStream = new GZIPInputStream((InputStream)CloseShieldInputStream.wrap((InputStream)arInputStream));
                    } else {
                        if (!arEntry.getName().equals("control.tar.xz")) continue;
                        decompInputStream = new XZCompressorInputStream((InputStream)CloseShieldInputStream.wrap((InputStream)arInputStream));
                    }
                    try {
                        DebArtifactReference debArtifactReference;
                        block55: {
                            block56: {
                                innerTarInputStream = new TarArchiveInputStream((InputStream)decompInputStream);
                                throwable = null;
                                try {
                                    TarArchiveEntry innerTarEntry;
                                    while ((innerTarEntry = innerTarInputStream.getNextEntry()) != null) {
                                        if (!controlFilePattern.matcher(innerTarEntry.getName()).matches()) {
                                            if (!log.isTraceEnabled()) continue;
                                            log.trace("Ignoring non-matching file [{}] inside control of [{}] for [{}].", new Object[]{innerTarEntry.getName(), debFile, diagnostic});
                                            continue;
                                        }
                                        String controlFileContent = IOUtils.toString((InputStream)innerTarInputStream, (Charset)StandardCharsets.UTF_8);
                                        DebianPackagesEntry parsedControl = DebianPackagesEntry.parseFromSnippet(controlFileContent, diagnostic);
                                        if (!Objects.equals(parsedControl.getVersion(), binaryRef.getVersion())) {
                                            log.warn("Parsed control file from, binary ref mismatch field version: [{}] vs [{}] while resolving [{}].", new Object[]{parsedControl.getVersion(), binaryRef.getVersion(), diagnostic});
                                        }
                                        if (!Objects.equals(parsedControl.getArchitecture(), binaryRef.getArchitecture())) {
                                            log.warn("Parsed control file and binary ref mismatch in architecture field: [{}] vs [{}] while resolving [{}].", new Object[]{parsedControl.getArchitecture(), binaryRef.getArchitecture(), diagnostic});
                                        }
                                        if (binaryRef.getNamespace() != DebArtifactReference.DebNamespace.UBUNTU) {
                                            log.debug("Unexpected namespace [{}] (expected [{}]) in ref [{}] while resolving [{}].", new Object[]{binaryRef.getNamespace().toString(), DebArtifactReference.DebNamespace.UBUNTU, binaryRef, diagnostic});
                                        }
                                        DebArtifactReference derivedSourceRef = new DebArtifactReference(parsedControl.getSourcePackageName(), parsedControl.getSourcePackageVersion(), parsedControl.getArchitecture(), binaryRef.getNamespace());
                                        log.debug("Derived source ref [{}] from parsed [{}] from deb [{}] of [{}].", new Object[]{derivedSourceRef, parsedControl, debFile.toPath(), diagnostic});
                                        debArtifactReference = derivedSourceRef;
                                        if (innerTarInputStream == null) return debArtifactReference;
                                        if (throwable == null) break block55;
                                        break block56;
                                    }
                                    break block57;
                                }
                                catch (Throwable throwable2) {
                                    try {
                                        throwable = throwable2;
                                        throw throwable2;
                                    }
                                    catch (Throwable throwable3) {
                                        if (innerTarInputStream == null) throw throwable3;
                                        if (throwable == null) {
                                            innerTarInputStream.close();
                                            throw throwable3;
                                        }
                                        try {
                                            innerTarInputStream.close();
                                            throw throwable3;
                                        }
                                        catch (Throwable throwable4) {
                                            throwable.addSuppressed(throwable4);
                                            throw throwable3;
                                        }
                                    }
                                }
                            }
                            try {
                                innerTarInputStream.close();
                                return debArtifactReference;
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                                return debArtifactReference;
                            }
                        }
                        innerTarInputStream.close();
                        return debArtifactReference;
                    }
                    catch (PackagesEntryParsingException e) {
                        log.warn("Failure to parse control file from deb [{}].", (Object)debFile.toPath(), (Object)e);
                        throw new RuntimeException(e);
                    }
                }
                if (innerTarInputStream == null) continue;
                if (throwable != null) {
                    try {
                        innerTarInputStream.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                innerTarInputStream.close();
            }
        }
        catch (IOException e) {
            log.warn("Exception while trying to read tar [{}] for [{}].", (Object)debFile.toPath(), (Object)diagnostic);
            log.info("Invalidating marker after read failure for file [{}] while resolving [{}].", (Object)debFile.toPath(), (Object)diagnostic);
            MarkerUtils.invalidateMarkerFor(debFile, diagnostic);
            throw new RuntimeException(e);
        }
        log.debug("Failed derivation from deb [{}] for binary ref [{}] for [{}].", new Object[]{debFile.toPath(), binaryRef, diagnostic});
        return null;
    }

    public DebArtifactReference getSourcePackageReference(DebArtifactReference binaryPackageRef, String diagnostic) {
        DebianPackagesEntry packagesEntry = this.ubuntuIndex.lookupNameVersionArch(binaryPackageRef.getName(), binaryPackageRef.getVersion(), binaryPackageRef.getArchitecture());
        if (packagesEntry != null && packagesEntry.getSourcePackageName() != null) {
            DebArtifactReference ref = new DebArtifactReference(packagesEntry.getSourcePackageName(), packagesEntry.getSourcePackageVersion(), packagesEntry.getArchitecture(), binaryPackageRef.getNamespace());
            log.trace("Using source ref [{}] derived from ubuntu 'Packages' file entry [{}] from binary ref [{}].", new Object[]{ref, packagesEntry, binaryPackageRef});
            return ref;
        }
        log.debug("Starting early download to get binary from ubuntu pool for binary ref [{}] for [{}].", (Object)binaryPackageRef, (Object)diagnostic);
        ResolverResult binaryDebResolverResult = this.ubuntuPoolAdapter.getBinaryFromPool(binaryPackageRef, null);
        File binaryDeb = binaryDebResolverResult.getResolvedFile();
        if (binaryDeb != null && binaryDeb.exists()) {
            log.trace("Start reading binary deb [{}] for binary ref [{}] to get source ref for [{}].", new Object[]{binaryDeb.toPath(), binaryPackageRef, diagnostic});
            DebArtifactReference sourceRef = this.getSourceRefFromDebFile(binaryDeb, binaryPackageRef, diagnostic);
            log.debug("Using source ref [{}] derived from binary deb [{}] from binary ref [{}] of [{}].", new Object[]{sourceRef, binaryDeb.getPath(), binaryPackageRef, diagnostic});
            return sourceRef;
        }
        log.debug("Could not resolve source reference for [{}] of [{}].", (Object)binaryPackageRef, (Object)diagnostic);
        return null;
    }

    protected Collection<ArtifactPartResolver> getArtifactResolverParts(PackageURL purl, Artifact artifact) {
        if (!"deb".equals(purl.getType())) {
            log.trace("Rejecting artifact [{}] by purl: purl not of type 'deb'", (Object)artifact.toString());
            return Collections.emptyList();
        }
        DebArtifactReference givenPackageRef = new DebArtifactReference(purl);
        if (!givenPackageRef.isValid()) {
            log.debug("The binary reference [{}] derived from parsed purl [{}] is invalid. Aborting.", (Object)givenPackageRef, (Object)purl);
            return Collections.emptyList();
        }
        HashSet<ArtifactPartResolver> parts = new HashSet<ArtifactPartResolver>();
        switch (givenPackageRef.getNamespace()) {
            case UBUNTU: {
                DebArtifactReference sourcePackageRef = "source".equals(givenPackageRef.getArchitecture()) ? givenPackageRef : this.getSourcePackageReference(givenPackageRef, artifact.toString());
                parts.add(new ArtifactPartResolver(artifact, ArtifactPartType.BINARY_ARTIFACT, () -> this.ubuntuPoolAdapter.getBinaryFromPool(givenPackageRef, sourcePackageRef), rap -> this.enrich((ResolvedArtifactPart)rap)));
                if (sourcePackageRef != null) {
                    parts.add(new ArtifactPartResolver(artifact, ArtifactPartType.SOURCE_ARTIFACT, () -> this.ubuntuLaunchpadAdapter.downloadSourceArtifact(sourcePackageRef), rap -> this.enrich((ResolvedArtifactPart)rap)));
                    break;
                }
                if (this.resolverConfig == null || !this.resolverConfig.isDesperateSourceResolve()) break;
                log.debug("Using desperate resolver using binary ref for sources of [{}]", (Object)artifact);
                parts.add(new ArtifactPartResolver(artifact, ArtifactPartType.SOURCE_ARTIFACT, () -> this.ubuntuLaunchpadAdapter.downloadSourceArtifact(givenPackageRef), rap -> this.enrich((ResolvedArtifactPart)rap)));
                break;
            }
            case DEBIAN: {
                log.trace("Debian resolver not supported yet.");
                break;
            }
            default: {
                log.debug("Type [{}] is not supported by this resolver.", (Object)givenPackageRef.getNamespace());
            }
        }
        return parts;
    }

    public Collection<ArtifactPartResolver> getArtifactResolverPartsForPurl(Artifact artifact) {
        PackageURL purl;
        String purlString = artifact.get(Artifact.Attribute.PURL);
        if (purlString == null) {
            log.trace("Rejecting null purl from artifact [{}].", (Object)artifact);
            return Collections.emptyList();
        }
        try {
            purl = new PackageURL(purlString);
        }
        catch (MalformedPackageURLException e) {
            log.info("Malformed purl trying to parse purl [{}] of artifact [{}].", (Object)purlString, (Object)artifact);
            artifact.append("Errors", String.format("[PURL [%s] malformed.]", purlString), "\n");
            return Collections.emptyList();
        }
        return this.getArtifactResolverParts(purl, artifact);
    }

    private Artifact enrich(ResolvedArtifactPart resolvedArtifactPart) {
        Artifact enrichedArtifact = new Artifact(resolvedArtifactPart.getOriginalArtifact());
        ArtifactPartType artifactPartType = resolvedArtifactPart.getArtifactPartType();
        File resolvedFile = resolvedArtifactPart.getResolvedFile();
        if (resolvedFile != null) {
            enrichedArtifact.set(artifactPartType.modulatePathAttribute(), resolvedFile.getAbsolutePath());
        }
        return enrichedArtifact;
    }
}

