/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.deb.index.packages;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.metaeffekt.artifact.resolver.deb.index.packages.config.DebIndexConfig;
import org.metaeffekt.artifact.resolver.deb.index.packages.config.PackagesFileType;
import org.metaeffekt.artifact.resolver.deb.index.packages.parser.DebianPackagesEntry;
import org.metaeffekt.artifact.resolver.download.WebAccess;
import org.metaeffekt.artifact.resolver.generic.utils.GenericUtils;
import org.metaeffekt.artifact.resolver.generic.utils.MarkerUtils;
import org.metaeffekt.artifact.resolver.generic.utils.exception.DownloadFailedException;
import org.metaeffekt.artifact.resolver.model.DownloadLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebPackagesIndex {
    private static final Logger log = LoggerFactory.getLogger(DebPackagesIndex.class);
    private final DownloadLocation downloadLocation;
    private final WebAccess webAccess;
    private final DebIndexConfig config;
    private final Map<String, Map<String, Map<String, Collection<DebianPackagesEntry>>>> nameToVersionToArchitecture = new HashMap<String, Map<String, Map<String, Collection<DebianPackagesEntry>>>>();
    private static final Pattern fileExtensionPattern = Pattern.compile("\\.[a-zA-Z]{1,16}$");
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    public DebPackagesIndex(DownloadLocation downloadLocation, WebAccess webAccess, DebIndexConfig indexConfig) {
        this.downloadLocation = downloadLocation;
        this.webAccess = webAccess;
        this.config = indexConfig == null ? new DebIndexConfig() : indexConfig;
    }

    @NonNull
    private static PackagesFileType deriveFileTypeFromUrlEnding(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (!url.equals(url.trim())) {
            log.warn("The url [{}] is untrimmed. This may lead to errors.", (Object)url);
        }
        if (url.endsWith("/Packages.gz")) {
            return PackagesFileType.GZIP;
        }
        if (url.endsWith("/Packages.xz")) {
            return PackagesFileType.XZ;
        }
        if (url.endsWith("/Packages")) {
            return PackagesFileType.RAW;
        }
        log.warn("Could not detect type of Packages file in [{}]. Assuming raw.", (Object)url);
        return PackagesFileType.RAW;
    }

    private void generateIndex(@NonNull List<String> sourceFileUrls) {
        if (sourceFileUrls == null) {
            throw new NullPointerException("sourceFileUrls is marked non-null but is null");
        }
        TreeMap<String, PackagesFileType> urlToDerivedType = new TreeMap<String, PackagesFileType>();
        for (String url : sourceFileUrls) {
            urlToDerivedType.put(url, null);
        }
        this.generateIndex(urlToDerivedType);
    }

    private InputStream getDecompressorStreamByType(@NonNull InputStream inputStream, @NonNull PackagesFileType fileType) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        if (fileType == null) {
            throw new NullPointerException("fileType is marked non-null but is null");
        }
        switch (fileType) {
            case XZ: {
                return new XZCompressorInputStream(inputStream, false);
            }
            case GZIP: {
                return new GzipCompressorInputStream(inputStream, false);
            }
            case RAW: {
                return new BufferedInputStream(inputStream, 8192);
            }
        }
        log.error("Reached default case with (unknown) enum value [{}] while trying to unpack.", (Object)fileType);
        throw new IllegalStateException("Could not unpack given file.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File decompressByType(@NonNull File toUnpack, @NonNull File destination, @NonNull PackagesFileType fileType) {
        if (toUnpack == null) {
            throw new NullPointerException("toUnpack is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (fileType == null) {
            throw new NullPointerException("fileType is marked non-null but is null");
        }
        try (OutputStream outputStream = Files.newOutputStream(destination.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            try (InputStream inputStream = Files.newInputStream(toUnpack.toPath(), new OpenOption[0]);
                 InputStream decompressor = this.getDecompressorStreamByType(inputStream, fileType);){
                IOUtils.copyLarge((InputStream)decompressor, (OutputStream)outputStream);
            }
            File file = destination;
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String urlToFilename(String url) {
        int lastDot = url.lastIndexOf(46);
        String uncleanEnding = lastDot != -1 ? url.substring(lastDot) : "";
        String clean = fileExtensionPattern.matcher(uncleanEnding).find() ? uncleanEnding : "";
        return "sha256-" + DigestUtils.sha256Hex((byte[])url.getBytes(StandardCharsets.UTF_8)) + clean;
    }

    @NonNull
    private File downloadIndex(@NonNull String url) throws DownloadFailedException {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        try {
            URL parsedUrl = new URL(url);
            File destinationFile = new File(new File(this.downloadLocation.deriveDownloadFolder("deb-index", parsedUrl.getHost()), "[" + parsedUrl.getHost() + "-" + this.urlToFilename(url) + "]"), this.urlToFilename(url));
            File downloaded = GenericUtils.downloadFile(this.webAccess, url, destinationFile, MarkerUtils.deriveMarkerFileFromDestination(destinationFile), this.getClass().getSimpleName());
            if (downloaded == null) {
                log.error("Could not download url [{}] to [{}].", (Object)url, (Object)destinationFile);
                throw new DownloadFailedException();
            }
            return downloaded;
        }
        catch (MalformedURLException e) {
            log.error("Got malformed URL while trying to download index from [{}].", (Object)url);
            throw new IllegalArgumentException("Can't download index files from url: ", e);
        }
    }

    private void generateIndex(@NonNull SortedMap<String, PackagesFileType> sourceFileUrlsToType) {
        if (sourceFileUrlsToType == null) {
            throw new NullPointerException("sourceFileUrlsToType is marked non-null but is null");
        }
        TreeMap<String, File> urlToFile = new TreeMap<String, File>();
        for (Map.Entry<String, PackagesFileType> entry2 : sourceFileUrlsToType.entrySet()) {
            File downloaded;
            String url = entry2.getKey();
            try {
                downloaded = this.downloadIndex(url);
            }
            catch (DownloadFailedException e) {
                log.warn("Failed to download [{}], will be excluded from index.", (Object)url);
                continue;
            }
            urlToFile.put(url, downloaded);
        }
        List collectedEntries = urlToFile.entrySet().stream().map(entry -> {
            List<DebianPackagesEntry> entries;
            String url = (String)entry.getKey();
            File downloaded = (File)entry.getValue();
            PackagesFileType fileType = (PackagesFileType)((Object)((Object)sourceFileUrlsToType.get(url)));
            if (fileType == null) {
                fileType = DebPackagesIndex.deriveFileTypeFromUrlEnding(url);
            }
            log.debug("Reading index from file [{}] of url [{}].", (Object)downloaded, (Object)url);
            try (InputStream inputStream = Files.newInputStream(downloaded.toPath(), new OpenOption[0]);
                 InputStream decompressor = this.getDecompressorStreamByType(inputStream, fileType);){
                entries = DebianPackagesEntry.getValidEntries(decompressor, downloaded.getPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (entries.isEmpty()) {
                log.warn("Pointless empty index content from [{}] at [{}]", (Object)url, (Object)downloaded);
            }
            return entries;
        }).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll);
        Collections.sort(collectedEntries);
        for (DebianPackagesEntry entry3 : collectedEntries) {
            String name = entry3.getPackageName();
            String version = entry3.getVersion();
            String architecture = entry3.getArchitecture();
            this.nameToVersionToArchitecture.computeIfAbsent(name, ignore -> new HashMap()).computeIfAbsent(version, ignore -> new HashMap()).computeIfAbsent(architecture, ignore -> new TreeSet()).add(entry3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebianPackagesEntry lookupNameVersionArch(@NonNull String name, @NonNull String version, @NonNull String arch) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        if (arch == null) {
            throw new NullPointerException("arch is marked non-null but is null");
        }
        AtomicBoolean atomicBoolean = this.initialized;
        synchronized (atomicBoolean) {
            if (!this.initialized.get()) {
                log.debug("Initializing lazy index...");
                this.generateIndex(this.config.getPackagesDownloadUrls());
                this.initialized.set(true);
            }
        }
        Collection result = ((Map)((Map)this.nameToVersionToArchitecture.getOrDefault(name, new HashMap())).getOrDefault(version, new HashMap())).getOrDefault(arch, Collections.emptySet());
        if (result.size() > 1) {
            log.warn("More than one result on lookup [{}], [{}], [{}]. Using first.", new Object[]{name, version, arch});
        }
        return result.stream().findFirst().orElse(null);
    }

    public Map<String, Map<String, Map<String, Collection<DebianPackagesEntry>>>> getNameToVersionToArchitecture() {
        return this.nameToVersionToArchitecture;
    }
}

