/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.deb.ubuntu;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.metaeffekt.artifact.resolver.ResolverResult;
import org.metaeffekt.artifact.resolver.deb.DebArtifactReference;
import org.metaeffekt.artifact.resolver.deb.index.pool.UbuntuPoolIndex;
import org.metaeffekt.artifact.resolver.deb.ubuntu.UbuntuPoolAdapterConfig;
import org.metaeffekt.artifact.resolver.download.WebAccess;
import org.metaeffekt.artifact.resolver.generic.AbstractDownloadingAdapter;
import org.metaeffekt.artifact.resolver.generic.FileLocation;
import org.metaeffekt.artifact.resolver.generic.utils.GenericUtils;
import org.metaeffekt.artifact.resolver.generic.utils.MarkerUtils;
import org.metaeffekt.artifact.resolver.model.DownloadLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UbuntuPoolAdapter
extends AbstractDownloadingAdapter {
    private static final Logger log = LoggerFactory.getLogger(UbuntuPoolAdapter.class);
    private final UbuntuPoolAdapterConfig config;
    @NonNull
    private final List<UbuntuPoolIndex> poolIndices = new ArrayList<UbuntuPoolIndex>();

    public UbuntuPoolAdapter(DownloadLocation downloadLocation, WebAccess webAccess, UbuntuPoolAdapterConfig config) {
        super(downloadLocation, webAccess);
        this.config = config;
        if (this.config != null) {
            for (String poolDir : config.getPoolDirs()) {
                UbuntuPoolIndex poolIndex = new UbuntuPoolIndex(downloadLocation, webAccess, poolDir);
                this.poolIndices.add(poolIndex);
            }
        }
    }

    @NonNull
    protected String getPoolPrefix(DebArtifactReference binaryPackageRef) {
        String packageName = binaryPackageRef.getName();
        if (packageName.startsWith("lib")) {
            return packageName.substring(0, 4);
        }
        return packageName.substring(0, 1);
    }

    protected String getFilenameForBinaryPackage(@NonNull DebArtifactReference binaryPackageRef) {
        if (binaryPackageRef == null) {
            throw new NullPointerException("binaryPackageRef is marked non-null but is null");
        }
        int colonIndex = binaryPackageRef.getVersion().indexOf(58);
        String versionWithoutEpoch = colonIndex == -1 ? binaryPackageRef.getVersion() : binaryPackageRef.getVersion().substring(colonIndex + 1);
        return binaryPackageRef.getName() + "_" + versionWithoutEpoch + "_" + binaryPackageRef.getArchitecture() + ".deb";
    }

    @NonNull
    protected List<String> getPoolUrls(@NonNull DebArtifactReference binaryPackageRef) {
        if (binaryPackageRef == null) {
            throw new NullPointerException("binaryPackageRef is marked non-null but is null");
        }
        String debFilename = this.getFilenameForBinaryPackage(binaryPackageRef);
        ArrayList<String> urls = new ArrayList<String>();
        for (UbuntuPoolIndex index : this.poolIndices) {
            try {
                List<String> pathsFromIndex = index.getDirectoriesFromFilename(debFilename);
                for (String path : pathsFromIndex) {
                    urls.add(path + "/" + this.getFilenameForBinaryPackage(binaryPackageRef));
                }
            }
            catch (Exception e) {
                log.debug("Ignoring unexpected Exception while trying to use index of [{}] while resolving [{}].", new Object[]{index, binaryPackageRef, e});
            }
        }
        return urls;
    }

    protected File downloadBinaryDeb(@NonNull DebArtifactReference binaryPackageRef, @NonNull String downloadFilename, @NonNull String fileUrl) {
        if (binaryPackageRef == null) {
            throw new NullPointerException("binaryPackageRef is marked non-null but is null");
        }
        if (downloadFilename == null) {
            throw new NullPointerException("downloadFilename is marked non-null but is null");
        }
        if (fileUrl == null) {
            throw new NullPointerException("fileUrl is marked non-null but is null");
        }
        if (!binaryPackageRef.isValid()) {
            return null;
        }
        FileLocation fileLocation = binaryPackageRef.deriveFileLocation(downloadFilename);
        File file = this.deriveDownloadFile(fileLocation);
        File markerFile = MarkerUtils.deriveMarkerFileFromDestination(file);
        File downloaded = GenericUtils.downloadFile(this.getWebAccess(), fileUrl, file, binaryPackageRef.toString());
        if (markerFile.exists() && !markerFile.delete()) {
            log.warn("Could not delete marker file for sub-download [{}] to file [{}]. May produce false negative.", (Object)fileUrl, (Object)file);
        }
        return downloaded;
    }

    public ResolverResult getBinaryFromPool(@NonNull DebArtifactReference binaryPackageRef, DebArtifactReference sourcePackageRef) {
        if (binaryPackageRef == null) {
            throw new NullPointerException("binaryPackageRef is marked non-null but is null");
        }
        log.trace("Resolving source package [{}] for given [{}].", (Object)sourcePackageRef, (Object)binaryPackageRef);
        if (this.config == null || this.config.getPoolDirs() == null || this.config.getPoolDirs().isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace("Not resolving [{}] because this resolver of class [{}] is not configured.", (Object)binaryPackageRef, (Object)this.getClass().getSimpleName());
            }
            return null;
        }
        if (!binaryPackageRef.isValid()) {
            log.trace("Not resolving invalid package ref [{}].", (Object)binaryPackageRef);
            return null;
        }
        String binaryDebFilename = this.getFilenameForBinaryPackage(binaryPackageRef);
        File destinationFile = this.deriveDownloadFile(binaryPackageRef.deriveFileLocation(binaryDebFilename));
        File markerFile = MarkerUtils.deriveMarkerFileFromDestination(destinationFile);
        return this.resolve(MarkerUtils.attemptDownload(markerFile, binaryPackageRef.toString(), () -> {
            List<String> urls = this.getPoolUrls(binaryPackageRef);
            for (String url : urls) {
                File downloaded = GenericUtils.downloadFile(this.getWebAccess(), url, destinationFile, binaryPackageRef.toString());
                if (downloaded == null) continue;
                return downloaded;
            }
            return null;
        }), null);
    }
}

