/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.generic;

import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import org.apache.http.HttpResponse;
import org.metaeffekt.artifact.resolver.download.WebAccess;
import org.metaeffekt.artifact.resolver.generic.AbstractAdapter;
import org.metaeffekt.artifact.resolver.generic.FileLocation;
import org.metaeffekt.artifact.resolver.generic.utils.MarkerUtils;
import org.metaeffekt.artifact.resolver.model.DownloadLocation;
import org.metaeffekt.core.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDownloadingAdapter
extends AbstractAdapter {
    private static final Logger log = LoggerFactory.getLogger(AbstractDownloadingAdapter.class);
    private final DownloadLocation downloadLocation;
    private final WebAccess webAccess;

    public AbstractDownloadingAdapter(DownloadLocation downloadLocation, WebAccess webAccess) {
        this.downloadLocation = downloadLocation;
        this.webAccess = webAccess;
    }

    protected void removeMarker(File markerFile) {
        if (markerFile.exists()) {
            FileUtils.deleteQuietly((File)markerFile);
        }
    }

    protected boolean hasRecentFailedDownloadAttempt(File markerFile) {
        return MarkerUtils.hasRecentDownloadAttempt(markerFile);
    }

    public File deriveDownloadFile(FileLocation fileLocation) {
        File resourceFolder = this.deriveResourceDir(fileLocation);
        return new File(resourceFolder, fileLocation.getFilename());
    }

    protected File deriveMarkerFile(FileLocation fileLocation, String markerDescriminator) {
        File resourceDir = this.deriveResourceDir(fileLocation);
        File markerDir = new File(resourceDir, "MARKER");
        File repoMarkerFile = new File(markerDir, "[" + markerDescriminator.replaceAll("[/:]+", "_") + "]");
        return repoMarkerFile;
    }

    protected File deriveResourceDir(FileLocation fileLocation) {
        File downloadDir = this.downloadLocation.deriveDownloadFolder(fileLocation.getEcosystem(), fileLocation.getDispatchName());
        File resourceFolder = new File(downloadDir, "[" + fileLocation.getResourceQualifier() + "]");
        return resourceFolder;
    }

    protected Consumer<HttpResponse> manageMarkerErrorResponseConsumer(File markerFile) {
        return httpResponse -> {
            try {
                FileUtils.forceMkdirParent((File)markerFile);
                if (!markerFile.createNewFile()) {
                    log.warn("Could not create marker file [{}].", (Object)markerFile);
                }
            }
            catch (IOException e) {
                log.warn("Could not manage marker file [{}].", (Object)markerFile);
            }
        };
    }

    public DownloadLocation getDownloadLocation() {
        return this.downloadLocation;
    }

    public WebAccess getWebAccess() {
        return this.webAccess;
    }
}

