/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.generic.index.lucene;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLuceneIndex
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(AbstractLuceneIndex.class);
    private final Analyzer analyzer;
    private final Directory directory;

    protected AbstractLuceneIndex(@NonNull File directoryPath, @NonNull Analyzer analyzer) throws IOException {
        if (directoryPath == null) {
            throw new NullPointerException("directoryPath is marked non-null but is null");
        }
        if (analyzer == null) {
            throw new NullPointerException("analyzer is marked non-null but is null");
        }
        this.directory = FSDirectory.open((Path)directoryPath.toPath());
        this.analyzer = analyzer;
    }

    @Override
    public void close() throws Exception {
        this.analyzer.close();
        this.directory.close();
    }

    protected TopDocs getTopDocs(Query query, int n, IndexSearcher searcher) throws IOException {
        return searcher.search(query, n);
    }

    @NonNull
    public List<Document> runQuery(Query query, int n, IndexSearcher searcher) throws IOException {
        ScoreDoc[] scoreDocs;
        ArrayList<Document> foundDocuments = new ArrayList<Document>();
        TopDocs topDocs = searcher.search(query, n);
        if (topDocs == null || topDocs.scoreDocs == null) {
            return Collections.emptyList();
        }
        for (ScoreDoc scoreDoc : scoreDocs = topDocs.scoreDocs) {
            Document foundDoc = searcher.doc(scoreDoc.doc);
            if (foundDoc != null) {
                foundDocuments.add(foundDoc);
                continue;
            }
            log.warn("Got unexpected null document while performing index search.");
        }
        return foundDocuments;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Directory getDirectory() {
        return this.directory;
    }
}

