/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.generic.index.lucene;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.metaeffekt.artifact.resolver.generic.index.lucene.AbstractLuceneIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLuceneIndex
extends AbstractLuceneIndex {
    private static final Logger log = LoggerFactory.getLogger(SimpleLuceneIndex.class);
    private static final String DEDUPLICATE = "DEDUPLICATE";
    private static final int DEFAULT_ANALYZER_MAX_WORD_LENGTH = 1024;
    private static final int WRITER_MAX_RAM_BUFFER_SIZE_MB = 128;
    private final IndexWriter writer;

    public SimpleLuceneIndex(@NonNull File indexDir, @NonNull Analyzer analyzer) throws IOException {
        super(indexDir, analyzer);
        if (indexDir == null) {
            throw new NullPointerException("indexDir is marked non-null but is null");
        }
        if (analyzer == null) {
            throw new NullPointerException("analyzer is marked non-null but is null");
        }
        IndexWriterConfig conf = new IndexWriterConfig(analyzer);
        conf.setCommitOnClose(true);
        conf.setRAMBufferSizeMB(128.0);
        conf.setUseCompoundFile(false);
        this.writer = new IndexWriter(this.getDirectory(), conf);
    }

    public SimpleLuceneIndex(@NonNull File indexDir) throws IOException {
        this(indexDir, (Analyzer)new WhitespaceAnalyzer(1024));
        if (indexDir == null) {
            throw new NullPointerException("indexDir is marked non-null but is null");
        }
    }

    public void addEntry(@NonNull Map<String, Collection<String>> keyValueMap) throws IOException {
        if (keyValueMap == null) {
            throw new NullPointerException("keyValueMap is marked non-null but is null");
        }
        Document document = new Document();
        if (keyValueMap.containsKey(DEDUPLICATE)) {
            log.error("Can't support key named [DEDUPLICATE]: key reserved by this class.");
            throw new IllegalArgumentException("Can't support key named [DEDUPLICATE]: key reserved by this class.");
        }
        for (Map.Entry<String, Collection<String>> entry : keyValueMap.entrySet()) {
            for (String value : entry.getValue()) {
                document.add((IndexableField)new TextField(entry.getKey(), value, Field.Store.YES));
            }
        }
        this.writer.addDocument((Iterable)document);
    }

    public void clear() throws IOException {
        this.writer.deleteAll();
        this.writer.forceMergeDeletes(false);
        this.writer.commit();
    }

    public void commit() throws IOException {
        this.writer.commit();
    }

    @NonNull
    public List<Document> lookupContains(@NonNull String key, @NonNull String value, int n) throws IOException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        TermQuery query = new TermQuery(new Term(key, value));
        try (DirectoryReader reader = DirectoryReader.open((IndexWriter)this.writer);){
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            List<Document> list = this.runQuery((Query)query, n, searcher);
            return list;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long size() {
        try (DirectoryReader reader = DirectoryReader.open((IndexWriter)this.writer);){
            long l = reader.numDocs();
            return l;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        this.writer.close();
        super.close();
    }
}

