/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.generic.utils;

import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpResponse;
import org.metaeffekt.artifact.resolver.download.WebAccess;
import org.metaeffekt.artifact.resolver.generic.utils.MarkerQueryResult;
import org.metaeffekt.artifact.resolver.generic.utils.MarkerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericUtils {
    private static final Logger log = LoggerFactory.getLogger(GenericUtils.class);

    public static boolean isModifiedInLast24Hours(File file) {
        Instant lastModified = Instant.ofEpochMilli(file.lastModified());
        return lastModified.plus(1L, ChronoUnit.DAYS).isAfter(Instant.now());
    }

    public static Consumer<HttpResponse> getHttpResponseErrorConsumer_invalidateMarker(@NonNull File markerFile, String ref) {
        if (markerFile == null) {
            throw new NullPointerException("markerFile is marked non-null but is null");
        }
        return httpResponse -> {
            log.trace("Got http response [{}] while resolving for ref [{}].", httpResponse, (Object)ref);
            MarkerUtils.invalidateMarkerFor(markerFile, ref);
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File downloadFile(@NonNull WebAccess webAccess, @NonNull String url, @NonNull File destinationFile, @NonNull String reference) {
        if (webAccess == null) {
            throw new NullPointerException("webAccess is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (destinationFile == null) {
            throw new NullPointerException("destinationFile is marked non-null but is null");
        }
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        try (WebAccess.WebSession session = webAccess.createSession();){
            log.info("Downloading [{}] for [{}].", (Object)url, (Object)reference);
            Optional<File> downloadedFile = session.downloadFile(url, destinationFile, httpResponse -> log.info("Download failed for url [{}] to dest [{}] with [{}].", new Object[]{url, destinationFile, httpResponse.getStatusLine()}));
            File file = downloadedFile.orElse(null);
            return file;
        }
        catch (IOException e) {
            log.warn("Failed to download url [{}] to dest [{}] for ref [{}] due to exception.", new Object[]{url, destinationFile.toPath(), reference, e});
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public static File downloadFile(@NonNull WebAccess webAccess, @NonNull String url, @NonNull File destination, @NonNull File markerFile, @NonNull String reference) {
        if (webAccess == null) {
            throw new NullPointerException("webAccess is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (markerFile == null) {
            throw new NullPointerException("markerFile is marked non-null but is null");
        }
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        MarkerQueryResult queryResult = MarkerUtils.queryMarker(markerFile, reference);
        if (queryResult.getFoundTarget() != null) {
            log.debug("Skipping successful download for ref [{}]: url [{}] to yield [{}]; marker gave [{}].", new Object[]{reference, url, destination.getPath(), queryResult.getFoundTarget()});
            return queryResult.getFoundTarget();
        }
        if (queryResult.isAttemptedRecently()) {
            log.info("Skipping failed download for ref [{}]: url [{}] for destination [{}] failed recently.", new Object[]{reference, url, destination.getPath()});
            return null;
        }
        MarkerUtils.touchMarker(markerFile, reference);
        try (WebAccess.WebSession session = webAccess.createSession();){
            log.info("Downloading [{}] for [{}].", (Object)url, (Object)reference);
            Optional<File> downloadedFile = session.downloadFile(url, destination, GenericUtils.getHttpResponseErrorConsumer_invalidateMarker(markerFile, reference));
            if (downloadedFile.isPresent()) {
                MarkerUtils.markSuccess(downloadedFile.orElse(null), markerFile, reference);
            }
            File file = downloadedFile.orElse(null);
            return file;
        }
        catch (IOException e) {
            log.warn("Failed to download [{}] to [{}] for [{}] with [{}].", new Object[]{url, destination.getAbsolutePath(), reference, ExceptionUtils.getStackTrace((Throwable)e)});
            return null;
        }
    }
}

