/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.maven;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.jdom2.JDOMException;
import org.metaeffekt.artifact.resolver.ArtifactResolver;
import org.metaeffekt.artifact.resolver.download.WebAccess;
import org.metaeffekt.artifact.resolver.generic.ArtifactIndex;
import org.metaeffekt.artifact.resolver.maven.MavenArtifactReference;
import org.metaeffekt.artifact.resolver.maven.MavenArtifactResolverConfig;
import org.metaeffekt.artifact.resolver.maven.MavenPomAdapter;
import org.metaeffekt.artifact.resolver.maven.MavenRepositoryAdapter;
import org.metaeffekt.artifact.resolver.maven.index.MavenCentralIndex;
import org.metaeffekt.artifact.resolver.model.ArtifactPartResolver;
import org.metaeffekt.artifact.resolver.model.ArtifactPartResolvers;
import org.metaeffekt.artifact.resolver.model.ArtifactPartType;
import org.metaeffekt.artifact.resolver.model.DownloadLocation;
import org.metaeffekt.artifact.resolver.model.ResolvedArtifactPart;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenArtifactResolver
implements ArtifactResolver {
    private static final Logger log = LoggerFactory.getLogger(MavenArtifactResolver.class);
    private static final int MAX_HITS = 120;
    private final MavenRepositoryAdapter repositoryAdapter;
    private final MavenPomAdapter pomAdapter = new MavenPomAdapter();
    private final ArtifactIndex artifactIndex;
    private MavenCentralIndex mavenCentralIndex;

    public MavenArtifactResolver(DownloadLocation downloadLocation, WebAccess webAccess, ArtifactIndex artifactIndex, MavenArtifactResolverConfig config) {
        this.repositoryAdapter = new MavenRepositoryAdapter(downloadLocation, webAccess, config);
        this.artifactIndex = artifactIndex;
        if (config.getMavenCentralIndexConfig() != null) {
            this.mavenCentralIndex = new MavenCentralIndex(downloadLocation, webAccess, config.getMavenCentralIndexConfig());
        }
    }

    private static MavenArtifactReference getReferenceForRepresentatives(@NonNull Document matchedRepresentative) {
        if (matchedRepresentative == null) {
            throw new NullPointerException("matchedRepresentative is marked non-null but is null");
        }
        MavenArtifactReference ref = new MavenArtifactReference();
        ref.setGroupId(matchedRepresentative.get("g"));
        ref.setArtifactId(matchedRepresentative.get("a"));
        ref.setVersion(matchedRepresentative.get("v"));
        ref.setPackaging(matchedRepresentative.get("p"));
        ref.setClassifier(matchedRepresentative.get("c"));
        return ref;
    }

    @Override
    public ArtifactPartResolvers collectResolvers(@NonNull Artifact artifact) {
        if (artifact == null) {
            throw new NullPointerException("artifact is marked non-null but is null");
        }
        HashSet<ArtifactPartResolver> parts = new HashSet<ArtifactPartResolver>();
        this.addArtifactResolverPartForPurl(parts, artifact);
        this.addArtifactResolverPartForGAV(parts, artifact);
        return new ArtifactPartResolvers(parts);
    }

    private void addArtifactResolverPartForGAV(Collection<ArtifactPartResolver> parts, Artifact artifact) {
        this.addPartResolvers(artifact, parts, new MavenArtifactReference(artifact));
    }

    private boolean isChecksumSame(@NonNull String artifactMd5ChecksumHex, @NonNull MavenArtifactReference clonedReference, @NonNull MavenArtifactReference representativeReference) throws IOException {
        if (artifactMd5ChecksumHex == null) {
            throw new NullPointerException("artifactMd5ChecksumHex is marked non-null but is null");
        }
        if (clonedReference == null) {
            throw new NullPointerException("clonedReference is marked non-null but is null");
        }
        if (representativeReference == null) {
            throw new NullPointerException("representativeReference is marked non-null but is null");
        }
        if (artifactMd5ChecksumHex.length() != 32) {
            log.error("Input hash not of size 32 for: reference [{}], md5 [{}].", (Object)clonedReference, (Object)artifactMd5ChecksumHex);
            return false;
        }
        MavenArtifactReference hashRef = new MavenArtifactReference(representativeReference, representativeReference.getClassifier() == null || "NA".equals(representativeReference.getClassifier()) ? "" : representativeReference.getClassifier(), (String)StringUtils.firstNonBlank((CharSequence[])new String[]{clonedReference.getPackaging(), clonedReference.getType(), "jar"}) + ".md5");
        try {
            File md5HashFile = this.repositoryAdapter.downloadArtifact(hashRef);
            if (md5HashFile == null) {
                log.debug("Could not download md5 file for reference [{}].", (Object)clonedReference);
                return false;
            }
            String fileContent = FileUtils.readFileToString((File)md5HashFile, (Charset)StandardCharsets.UTF_8).trim();
            return StringUtils.equalsIgnoreCase((CharSequence)fileContent, (CharSequence)artifactMd5ChecksumHex);
        }
        catch (Exception e) {
            return false;
        }
    }

    private void addPartResolvers(Artifact artifact, Collection<ArtifactPartResolver> parts, MavenArtifactReference mavenArtifactReference) {
        MavenArtifactReference clonedReference;
        block8: {
            MavenArtifactReference mappedReference;
            clonedReference = new MavenArtifactReference(mavenArtifactReference, null, null);
            if (StringUtils.isBlank((CharSequence)clonedReference.getGroupId()) && (mappedReference = this.artifactIndex.map(artifact.getId(), artifact.getChecksum())) != null) {
                clonedReference.setGroupId(mappedReference.getGroupId());
                clonedReference.setArtifactId(mappedReference.getArtifactId());
                if (StringUtils.isBlank((CharSequence)clonedReference.getVersion())) {
                    clonedReference.setVersion(mappedReference.getVersion());
                }
            }
            if ((StringUtils.isBlank((CharSequence)clonedReference.getGroupId()) || StringUtils.isBlank((CharSequence)clonedReference.getVersion())) && StringUtils.isNotBlank((CharSequence)clonedReference.getObservedFileName()) && this.mavenCentralIndex != null) {
                try {
                    this.mavenCentralIndex.ensureInitialized();
                    String observedFileName = clonedReference.getObservedFileName();
                    if (observedFileName.length() <= 4) break block8;
                    Collection<Document> matchedRepresentatives = this.getRepresentativesByFilename(observedFileName);
                    if (!matchedRepresentatives.isEmpty()) {
                        log.debug("[Filename], [(comma-separated) matched representatives]: [{}], [{}]", (Object)observedFileName, (Object)matchedRepresentatives.stream().map(rep -> new StringJoiner(":").add(rep.get("g")).add(rep.get("a")).add(rep.get("v")).add(rep.get("c")).add(rep.get("p")).toString()).collect(Collectors.joining(", ")));
                    }
                    for (Document matchedRepresentative : matchedRepresentatives) {
                        if (matchedRepresentative == null) continue;
                        MavenArtifactReference repRef = MavenArtifactResolver.getReferenceForRepresentatives(matchedRepresentative);
                        if (artifact.getChecksum() != null && !this.isChecksumSame(artifact.getChecksum().trim(), clonedReference, repRef)) continue;
                        clonedReference.setGroupId(repRef.getGroupId());
                        clonedReference.setArtifactId(repRef.getArtifactId());
                        clonedReference.setVersion(repRef.getVersion());
                        break;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (clonedReference.isValid()) {
            parts.add(new ArtifactPartResolver(artifact, ArtifactPartType.DESCRIPTOR, () -> this.repositoryAdapter.resolvePom(clonedReference), rap -> this.enrich(clonedReference, (ResolvedArtifactPart)rap)));
            parts.add(new ArtifactPartResolver(artifact, ArtifactPartType.BINARY_ARTIFACT, () -> this.repositoryAdapter.resolveBinaryArtifact(clonedReference), rap -> this.enrich(clonedReference, (ResolvedArtifactPart)rap)));
            parts.add(new ArtifactPartResolver(artifact, ArtifactPartType.SOURCE_ARTIFACT, () -> this.repositoryAdapter.resolveSourceArtifact(clonedReference), rap -> this.enrich(clonedReference, (ResolvedArtifactPart)rap)));
        }
    }

    @NonNull
    private Collection<Document> getRepresentativesByFilename(String observedFileName) throws IOException {
        String queryString = MavenCentralIndex.sanitizeForWildcardQuery(observedFileName);
        List<Document> documents = this.mavenCentralIndex.queryByFilename(queryString, 120);
        if (documents.size() == 1) {
            return documents;
        }
        if (observedFileName.endsWith(".jar") ? !(documents = this.mavenCentralIndex.queryByFilename(queryString = MavenCentralIndex.sanitizeForWildcardQuery(observedFileName.substring(0, observedFileName.length() - 4) + ".pom.sha") + "*", 120)).isEmpty() : !(documents = this.mavenCentralIndex.queryByFilename(MavenCentralIndex.sanitizeForWildcardQuery(observedFileName + ".") + "*", 120)).isEmpty()) {
            return documents;
        }
        return Collections.emptyList();
    }

    private Artifact enrich(MavenArtifactReference mavenArtifactReference, ResolvedArtifactPart resolveArtifactPart) {
        Artifact enrichedArtifact = new Artifact(resolveArtifactPart.getOriginalArtifact());
        File resolvedFile = resolveArtifactPart.getResolvedFile();
        ArtifactPartType artifactPartType = resolveArtifactPart.getArtifactPartType();
        enrichedArtifact.set(artifactPartType.modulatePathAttribute(), resolvedFile.getAbsolutePath());
        enrichedArtifact.set(artifactPartType.modulateAttributeInContext("Hash (SHA-256)"), FileUtils.computeSHA256Hash((File)resolvedFile));
        if (ArtifactPartType.DESCRIPTOR.equals((Object)artifactPartType)) {
            try {
                this.pomAdapter.augmentLicenseMetaData(enrichedArtifact, mavenArtifactReference, resolvedFile);
            }
            catch (IOException | JDOMException e) {
                log.warn("Cannot resolve descriptor of [{}].", (Object)resolvedFile.getAbsolutePath());
            }
        }
        return enrichedArtifact;
    }

    private void addArtifactResolverPartForPurl(Collection<ArtifactPartResolver> parts, Artifact artifact) {
        String purl = artifact.get("PURL");
        if (!StringUtils.isEmpty((CharSequence)purl)) {
            try {
                MavenArtifactReference mavenArtifactReference = new MavenArtifactReference(new PackageURL(purl));
                this.addPartResolvers(artifact, parts, mavenArtifactReference);
            }
            catch (MalformedPackageURLException e) {
                artifact.append("Errors", String.format("[PURL [%s] malformed.]", purl), "\n");
            }
        }
    }
}

