/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.maven.index.lucene;

import java.io.File;
import java.io.IOException;
import java.util.List;
import lombok.NonNull;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.metaeffekt.artifact.resolver.generic.index.lucene.AbstractLuceneIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenLuceneIndex
extends AbstractLuceneIndex {
    private static final Logger log = LoggerFactory.getLogger(MavenLuceneIndex.class);
    private final IndexReader reader;
    private final IndexSearcher searcher;

    public MavenLuceneIndex(@NonNull File indexDir, @NonNull Analyzer analyzer) throws IOException {
        super(indexDir, analyzer);
        if (indexDir == null) {
            throw new NullPointerException("indexDir is marked non-null but is null");
        }
        if (analyzer == null) {
            throw new NullPointerException("analyzer is marked non-null but is null");
        }
        this.reader = DirectoryReader.open((Directory)this.getDirectory());
        this.searcher = new IndexSearcher(this.reader);
    }

    @NonNull
    public List<Document> lookupContains(@NonNull String key, @NonNull String value, int n) throws IOException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.runQuery((Query)new TermQuery(new Term(key, value)), n, this.searcher);
    }

    @NonNull
    public List<Document> runQuery(Query query, int n) throws IOException {
        return this.runQuery(query, n, this.searcher);
    }

    public long size() {
        return this.reader.numDocs();
    }

    @Override
    public void close() throws Exception {
        this.reader.close();
        super.close();
    }
}

