/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.model;

import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.metaeffekt.artifact.resolver.ResolverResult;
import org.metaeffekt.artifact.resolver.model.ArtifactPartType;
import org.metaeffekt.artifact.resolver.model.ResolvedArtifactPart;
import org.metaeffekt.core.inventory.processor.model.Artifact;

public class ArtifactPartResolver {
    private final Artifact artifact;
    private final ArtifactPartType artifactPartType;
    private final Supplier<ResolverResult> artifactPartSupplier;
    private final Function<ResolvedArtifactPart, Artifact> enrichmentFunction;

    public ArtifactPartResolver(Artifact artifact, ArtifactPartType artifactPartType, Supplier<ResolverResult> artifactSupplier, Function<ResolvedArtifactPart, Artifact> enrichmentFunction) {
        this.artifact = artifact;
        this.artifactPartType = artifactPartType;
        this.artifactPartSupplier = artifactSupplier;
        this.enrichmentFunction = enrichmentFunction;
    }

    public ResolvedArtifactPart get() {
        ResolverResult resolverResult;
        try {
            resolverResult = this.artifactPartSupplier.get();
            if (resolverResult == null) {
                return null;
            }
        }
        catch (Exception e) {
            resolverResult = new ResolverResult(null, "Cannot resolve.");
        }
        ResolvedArtifactPart resolvedArtifactPart = new ResolvedArtifactPart(resolverResult, this.artifact, this.artifactPartType);
        resolvedArtifactPart.applyEnrichment(this.enrichmentFunction);
        Artifact enrichedArtifact = resolvedArtifactPart.getEnrichedArtifact();
        String error = resolverResult.getErrorMessage();
        if (StringUtils.isNotBlank((CharSequence)error)) {
            String errorAttribute = this.artifactPartType.modulateAttributeInContext("Errors");
            enrichedArtifact.append(errorAttribute, error, ", ");
        }
        return resolvedArtifactPart;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public ArtifactPartType getArtifactPartType() {
        return this.artifactPartType;
    }
}

