/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.model;

import java.io.File;
import java.util.Locale;

public class DownloadLocation {
    private final File downloadBaseDir;

    public DownloadLocation(File downloadBaseDir) {
        this.downloadBaseDir = downloadBaseDir;
    }

    public File deriveDownloadFolder(String ecosystem, String dirName) {
        File ecosystemDir = new File(this.downloadBaseDir, ecosystem);
        return DownloadLocation.deriveDownloadDir(ecosystemDir, dirName);
    }

    private static File deriveDownloadDir(File ecosystemDir, String dirName) {
        String idLowerCase = dirName.toLowerCase(Locale.US).trim();
        idLowerCase = idLowerCase.replace("/", "_");
        idLowerCase = idLowerCase.replace("\\", "_");
        idLowerCase = idLowerCase.replace(":", "_");
        int length = idLowerCase.length();
        String level1 = "[" + idLowerCase.substring(0, Math.min(length, 1)) + "]";
        String level2 = "[" + idLowerCase.substring(0, Math.min(length, 2)) + "]";
        String level3 = "[" + idLowerCase + "]";
        return new File(new File(new File(ecosystemDir, level1), level2), level3);
    }
}

