/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.npm;

import com.github.packageurl.PackageURL;
import org.apache.commons.lang3.StringUtils;
import org.metaeffekt.artifact.resolver.generic.FileLocation;
import org.metaeffekt.core.inventory.processor.model.Artifact;

public class NpmArtifactReference {
    private String group;
    private String name;
    private String version;

    public NpmArtifactReference(String group, String name, String version) {
        this.group = group;
        this.name = name;
        this.version = version;
    }

    public NpmArtifactReference(PackageURL packageURL) {
        if (packageURL.getType().equalsIgnoreCase("npm")) {
            this.group = packageURL.getNamespace();
            this.name = packageURL.getName();
            this.version = packageURL.getVersion();
        } else {
            this.group = null;
            this.name = null;
            this.version = null;
        }
    }

    public NpmArtifactReference(Artifact artifact) {
        if (!"nodejs-module".equals(artifact.get("Type"))) {
            return;
        }
        String id = artifact.getId();
        if (id != null) {
            int slashEndIndex = id.lastIndexOf("/");
            this.version = artifact.getVersion();
            if (slashEndIndex != -1) {
                this.group = id.substring(0, slashEndIndex);
                this.name = id.substring(slashEndIndex + 1).replace("-" + this.version, "");
            } else {
                this.group = null;
                this.name = id.replace("-" + this.version, "");
            }
        } else {
            this.group = null;
            this.name = null;
            this.version = null;
        }
    }

    public String deriveUrlPart() {
        if (StringUtils.isNotEmpty((CharSequence)this.group)) {
            return String.format("%s/%s/-/%s-%s.tgz", this.group, this.name, this.name, this.version);
        }
        return String.format("%s/-/%s-%s.tgz", this.name, this.name, this.version);
    }

    public boolean isValid() {
        return StringUtils.isNotEmpty((CharSequence)this.name) && StringUtils.isNotEmpty((CharSequence)this.version);
    }

    public String deriveDownloadFileName() {
        return String.format("%s-%s.tgz", this.name, this.version);
    }

    public FileLocation deriveFileLocation() {
        String filename = this.deriveDownloadFileName();
        FileLocation fileLocation = new FileLocation();
        fileLocation.setEcosystem("npm");
        fileLocation.setFilename(filename);
        if (StringUtils.isBlank((CharSequence)this.group)) {
            fileLocation.setResourceQualifier(filename);
        } else {
            fileLocation.setResourceQualifier(String.format("%s-%s", this.group, filename));
        }
        if (StringUtils.isBlank((CharSequence)this.group)) {
            fileLocation.setDispatchName(this.name);
        } else {
            fileLocation.setDispatchName(String.format("%s-%s", this.group, this.name));
        }
        return fileLocation;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }
}

