/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.npm;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.metaeffekt.artifact.resolver.ArtifactResolver;
import org.metaeffekt.artifact.resolver.download.WebAccess;
import org.metaeffekt.artifact.resolver.model.ArtifactPartResolver;
import org.metaeffekt.artifact.resolver.model.ArtifactPartResolvers;
import org.metaeffekt.artifact.resolver.model.ArtifactPartType;
import org.metaeffekt.artifact.resolver.model.DownloadLocation;
import org.metaeffekt.artifact.resolver.model.ResolvedArtifactPart;
import org.metaeffekt.artifact.resolver.npm.NpmArtifactReference;
import org.metaeffekt.artifact.resolver.npm.NpmRepositoryAdapter;
import org.metaeffekt.core.inventory.processor.model.Artifact;

public class NpmArtifactResolver
implements ArtifactResolver {
    private NpmRepositoryAdapter repositoryAdapter;

    public NpmArtifactResolver(DownloadLocation downloadLocation, WebAccess webAccess) {
        this.repositoryAdapter = new NpmRepositoryAdapter(downloadLocation, webAccess);
    }

    @Override
    public ArtifactPartResolvers collectResolvers(@NonNull Artifact artifact) {
        if (artifact == null) {
            throw new NullPointerException("artifact is marked non-null but is null");
        }
        HashSet<ArtifactPartResolver> parts = new HashSet<ArtifactPartResolver>();
        this.addArtifactResolverPartForPurl(parts, artifact);
        this.addArtifactResolverPartForNV(parts, artifact);
        return new ArtifactPartResolvers(parts);
    }

    private void addArtifactResolverPartForNV(Collection<ArtifactPartResolver> parts, Artifact artifact) {
        this.addPartResolvers(artifact, parts, new NpmArtifactReference(artifact));
    }

    private void addPartResolvers(Artifact artifact, Collection<ArtifactPartResolver> parts, NpmArtifactReference artifactReference) {
        if (artifactReference.isValid()) {
            parts.add(new ArtifactPartResolver(artifact, ArtifactPartType.SOURCE_ARCHIVE, () -> this.repositoryAdapter.resolveSourceArchive(artifactReference), rap -> this.enrich(artifactReference, (ResolvedArtifactPart)rap)));
        }
    }

    private Artifact enrich(NpmArtifactReference reference, ResolvedArtifactPart resolvedArtifactPart) {
        Artifact enrichedArtifact = new Artifact(resolvedArtifactPart.getOriginalArtifact());
        enrichedArtifact.setVersion(reference.getVersion());
        if (StringUtils.isBlank((CharSequence)reference.getGroup())) {
            enrichedArtifact.setId(reference.getName() + "-" + reference.getVersion());
        } else {
            enrichedArtifact.setId(reference.getGroup() + "/" + reference.getName() + "-" + reference.getVersion());
        }
        File resolvedFile = resolvedArtifactPart.getResolvedFile();
        if (resolvedFile != null) {
            ArtifactPartType artifactPartType = resolvedArtifactPart.getArtifactPartType();
            enrichedArtifact.set(artifactPartType.modulatePathAttribute(), resolvedFile.getAbsolutePath());
        }
        return enrichedArtifact;
    }

    private void addArtifactResolverPartForPurl(Collection<ArtifactPartResolver> parts, Artifact artifact) {
        String purl = artifact.get("PURL");
        if (!StringUtils.isEmpty((CharSequence)purl)) {
            try {
                NpmArtifactReference artifactReference = new NpmArtifactReference(new PackageURL(purl));
                this.addPartResolvers(artifact, parts, artifactReference);
            }
            catch (MalformedPackageURLException e) {
                artifact.append("Errors", String.format("[PURL [%s] malformed.]", purl), "\n");
            }
        }
    }
}

