/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.pypi;

import com.github.packageurl.PackageURL;
import org.apache.commons.lang3.StringUtils;
import org.metaeffekt.artifact.resolver.generic.FileLocation;
import org.metaeffekt.core.inventory.processor.model.Artifact;

public class PyPIArtifactReference {
    private String name;
    private String version;

    public PyPIArtifactReference(String name, String version) {
        this.name = name;
        this.version = version;
    }

    public PyPIArtifactReference(PackageURL packageURL) {
        if (packageURL.getType().equalsIgnoreCase("pypi")) {
            this.name = packageURL.getName();
            this.version = packageURL.getVersion();
        } else {
            this.name = null;
            this.version = null;
        }
    }

    public PyPIArtifactReference(Artifact artifact) {
        if (!"python-package".equals(artifact.get("Type"))) {
            return;
        }
        String id = artifact.getId();
        if (id != null) {
            int slashEndIndex = id.lastIndexOf("/");
            this.version = artifact.getVersion();
            this.name = slashEndIndex != -1 ? id.substring(slashEndIndex + 1).replace("-" + this.version, "") : id.replace("-" + this.version, "");
        } else {
            this.name = null;
            this.version = null;
        }
    }

    public String derivePipRequirementSpec() {
        return String.format("%s==%s", this.name, this.version);
    }

    public boolean isValid() {
        return StringUtils.isNotEmpty((CharSequence)this.name) && StringUtils.isNotEmpty((CharSequence)this.version);
    }

    public String deriveMarkerFileName(String modifier) {
        return String.format("%s-%s-%s.marker", this.name, this.version, modifier);
    }

    public FileLocation deriveFileLocation() {
        FileLocation fileLocation = new FileLocation();
        fileLocation.setEcosystem("pypi");
        String qualifier = this.getName() + "-" + this.getVersion();
        fileLocation.setFilename(qualifier);
        fileLocation.setResourceQualifier(qualifier);
        fileLocation.setDispatchName(this.getName());
        return fileLocation;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }
}

