/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.pypi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.metaeffekt.artifact.resolver.ResolverResult;
import org.metaeffekt.artifact.resolver.generic.AbstractCliAdapter;
import org.metaeffekt.artifact.resolver.generic.FileLocation;
import org.metaeffekt.artifact.resolver.model.DownloadLocation;
import org.metaeffekt.artifact.resolver.pypi.PyPIArtifactReference;
import org.metaeffekt.core.util.ExecUtils;
import org.metaeffekt.core.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PyPICliAdapter
extends AbstractCliAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(PyPICliAdapter.class);

    public PyPICliAdapter(DownloadLocation downloadLocation) {
        super(downloadLocation);
    }

    public ResolverResult resolveSourceArtifact(PyPIArtifactReference artifactReference) {
        ArrayList<String> commandParts = new ArrayList<String>();
        commandParts.add("python3");
        commandParts.add("-m");
        commandParts.add("pip");
        commandParts.add("download");
        commandParts.add("--no-deps");
        commandParts.add("--no-dependencies");
        commandParts.add("--no-binary");
        commandParts.add(":all:");
        commandParts.add(artifactReference.derivePipRequirementSpec());
        String modifier = "source";
        return this.resolveArtifactUsingCommand(artifactReference, commandParts, "source");
    }

    public ResolverResult resolveBinaryArtifact(PyPIArtifactReference artifactReference) {
        ArrayList<String> commandParts = new ArrayList<String>();
        commandParts.add("python3");
        commandParts.add("-m");
        commandParts.add("pip");
        commandParts.add("download");
        commandParts.add("--no-deps");
        commandParts.add("--only-binary");
        commandParts.add(":all:");
        commandParts.add(artifactReference.derivePipRequirementSpec());
        String partModifier = "binary";
        return this.resolveArtifactUsingCommand(artifactReference, commandParts, "binary");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResolverResult resolveArtifactUsingCommand(PyPIArtifactReference artifactReference, List<String> commandParts, String partModifier) {
        FileLocation fileLocation = artifactReference.deriveFileLocation();
        File targetFolder = this.getDownloadLocation().deriveDownloadFolder(fileLocation.getEcosystem(), fileLocation.getFilename());
        String artifactQualifier = artifactReference.derivePipRequirementSpec();
        String markerFileName = artifactReference.deriveMarkerFileName(partModifier);
        File markerBaseDir = new File(targetFolder, "markers");
        File markerFile = new File(markerBaseDir, markerFileName);
        boolean reattempt = false;
        if (markerFile.exists() && markerFile.length() > 0L) {
            reattempt = true;
            try {
                String downloadedFilePath = FileUtils.readFileToString((File)markerFile, (String)"UTF-8");
                File downloadedFile = new File(downloadedFilePath);
                if (downloadedFile.exists()) {
                    reattempt = false;
                    LOG.info("Skipping download for ref [{}]: file [{}] exists.", (Object)artifactQualifier, (Object)downloadedFile);
                    return this.resolve(downloadedFile);
                }
            }
            catch (IOException e) {
                LOG.info("Detected incomplete download. Reattempting [{}].", (Object)artifactQualifier);
            }
        }
        if (!reattempt && this.hasRecentFailedDownloadAttempt(markerFile)) {
            LOG.info("Skipping download [{}]. Recent attempt failed.", (Object)artifactQualifier);
            return null;
        }
        File downloadFolder = new File(markerBaseDir, "tmp-" + partModifier);
        String errorMessage = null;
        if (!downloadFolder.exists()) {
            try {
                FileUtils.forceMkdir((File)downloadFolder);
            }
            catch (IOException e) {
                errorMessage = "Cannot create intermediate download folder: " + downloadFolder;
            }
        }
        if (downloadFolder.exists()) {
            try {
                ExecUtils.ExecParam execParam = new ExecUtils.ExecParam(commandParts);
                execParam.retainErrorOutputs();
                execParam.setWorkingDir(downloadFolder);
                ExecUtils.executeAndThrowIOExceptionOnFailure((ExecUtils.ExecParam)execParam);
                File downloadedFile = FileUtils.findSingleFile((File)downloadFolder, (String[])new String[]{"*.*"});
                if (downloadedFile != null) {
                    File targetFile = new File(targetFolder, downloadedFile.getName());
                    if (targetFile.exists()) {
                        FileUtils.deleteQuietly((File)targetFile);
                    }
                    FileUtils.moveFile((File)downloadedFile, (File)targetFile);
                    FileUtils.write((File)markerFile, (CharSequence)targetFile.getCanonicalFile().getAbsolutePath(), (String)"UTF-8");
                    ResolverResult resolverResult = this.resolve(targetFile);
                    return resolverResult;
                }
                errorMessage = String.format("Downloaded file for %s not detected in folder %s", artifactQualifier, downloadFolder);
            }
            catch (IOException e) {
                errorMessage = e.getMessage();
            }
            finally {
                FileUtils.deleteDirectoryQuietly((File)downloadFolder);
            }
        }
        LOG.error("Cannot access PyPI package {}. {}", (Object)artifactReference.derivePipRequirementSpec(), errorMessage);
        try {
            FileUtils.touch((File)markerFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

