/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.artifact.resolver.rpm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.packagedrone.utils.rpm.RpmBaseTag;
import org.eclipse.packagedrone.utils.rpm.RpmTag;
import org.eclipse.packagedrone.utils.rpm.parse.RpmInputStream;
import org.metaeffekt.artifact.resolver.ResolverResult;
import org.metaeffekt.artifact.resolver.download.WebAccess;
import org.metaeffekt.artifact.resolver.generic.AbstractDownloadingAdapter;
import org.metaeffekt.artifact.resolver.generic.FileLocation;
import org.metaeffekt.artifact.resolver.model.DownloadLocation;
import org.metaeffekt.artifact.resolver.rpm.RpmArtifactReference;
import org.metaeffekt.artifact.resolver.rpm.index.RpmIndex;
import org.metaeffekt.artifact.resolver.rpm.index.RpmIndexConfig;
import org.metaeffekt.artifact.resolver.rpm.index.RpmIndexPackageData;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpmRepositoryAdapter
extends AbstractDownloadingAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(RpmRepositoryAdapter.class);
    private final RpmIndex rpmIndex;

    public RpmRepositoryAdapter(DownloadLocation downloadLocation, WebAccess webAccess, RpmIndexConfig rpmIndexConfig) {
        super(downloadLocation, webAccess);
        this.rpmIndex = new RpmIndex(rpmIndexConfig);
    }

    private File downloadArtifact(RpmArtifactReference reference, String defaultArch) {
        try {
            File download;
            Set<String> urls;
            Optional firstUrl;
            Set<RpmIndexPackageData> packageSet = this.rpmIndex.queryPackageData(reference.getName());
            String archOrSource = reference.getArchOrSource() == null ? defaultArch : reference.getArchOrSource();
            Set<RpmIndexPackageData> filteredSet = RpmIndexPackageData.filter(packageSet, reference.getVersion(), archOrSource);
            Optional first = filteredSet.stream().findFirst();
            if (first.isPresent() && (firstUrl = (urls = this.rpmIndex.getRpmUrl((RpmIndexPackageData)first.get())).stream().findFirst()).isPresent() && (download = this.download(reference, (RpmIndexPackageData)first.get(), (String)firstUrl.get())) != null) {
                return download;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private File download(RpmArtifactReference reference, RpmIndexPackageData rpmPackageData, String uri) throws IOException {
        FileLocation fileLocation = reference.deriveFileLocation();
        File file = new File(this.deriveResourceDir(fileLocation), rpmPackageData.toFilename());
        File markerFile = this.deriveMarkerFile(fileLocation, uri);
        if (!file.exists()) {
            if (uri.startsWith("http")) {
                if (this.hasRecentFailedDownloadAttempt(markerFile)) {
                    LOG.info("Skipping download [{}]. Recent attempt failed:" + file.getAbsolutePath(), (Object)uri);
                    return null;
                }
                this.removeMarker(markerFile);
                try (WebAccess.WebSession session = this.getWebAccess().createSession();){
                    LOG.info("Downloading: [{}]", (Object)uri);
                    Optional<File> downloadFile = session.downloadFile(uri, file, this.manageMarkerErrorResponseConsumer(markerFile));
                    File file2 = downloadFile.orElse(null);
                    return file2;
                }
            }
        } else {
            LOG.debug("Skipping download [{}]. File already exists: " + file.getAbsolutePath(), (Object)uri);
        }
        return file;
    }

    public ResolverResult resolveBinaryArtifact(RpmArtifactReference artifactReference) {
        File resolveFile = this.downloadArtifact(artifactReference, "x86_64");
        if (resolveFile == null) {
            resolveFile = this.downloadArtifact(artifactReference, "noarch");
        }
        return this.resolve(resolveFile);
    }

    public ResolverResult resolveSourceArtifact(RpmArtifactReference artifactReference) {
        String sourcePackage;
        Artifact artifact;
        ResolverResult resolverResult = this.resolveBinaryArtifact(artifactReference);
        if (resolverResult != null && (artifact = this.extractMetaData(resolverResult.getResolvedFile())) != null && StringUtils.isNotBlank((CharSequence)(sourcePackage = artifact.get("Source Package")))) {
            RpmIndexPackageData rpmIndexPackageData = new RpmIndexPackageData(sourcePackage);
            RpmArtifactReference sourceRef = new RpmArtifactReference(rpmIndexPackageData.getName(), rpmIndexPackageData.getVersion() + "-" + rpmIndexPackageData.getRelease(), artifactReference.getVendor(), rpmIndexPackageData.getArchOrSource(), artifactReference.getDistro(), artifactReference.getEpoch());
            return this.resolve(this.downloadArtifact(sourceRef, sourceRef.getArchOrSource()));
        }
        return null;
    }

    protected Artifact extractMetaData(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            if (Files.isSymbolicLink(file.toPath())) {
                return null;
            }
            Artifact artifact = new Artifact();
            artifact.setId(file.getName());
            artifact.addRootPath(file.getAbsolutePath());
            try (RpmInputStream in = new RpmInputStream((InputStream)new FileInputStream(file));){
                String[] summary = (String[])in.getPayloadHeader().getTag((RpmBaseTag)RpmTag.SUMMARY);
                artifact.set("Summary", Arrays.stream(summary).collect(Collectors.joining("\n")));
                artifact.setComponent((String)in.getPayloadHeader().getTag((RpmBaseTag)RpmTag.NAME));
                artifact.set("Vendor", (String)in.getPayloadHeader().getTag((RpmBaseTag)RpmTag.VENDOR));
                artifact.set("Version", (String)in.getPayloadHeader().getTag((RpmBaseTag)RpmTag.VERSION));
                artifact.set("Release", (String)in.getPayloadHeader().getTag((RpmBaseTag)RpmTag.RELEASE));
                artifact.set("Source Package", (String)in.getPayloadHeader().getTag((RpmBaseTag)RpmTag.SOURCE_PACKAGE));
                artifact.set("Build Host", (String)in.getPayloadHeader().getTag((RpmBaseTag)RpmTag.BUILDHOST));
                artifact.set("Specified Package License", (String)in.getPayloadHeader().getTag((RpmBaseTag)RpmTag.LICENSE));
                String[] changeLogAuthors = (String[])in.getPayloadHeader().getTag((RpmBaseTag)RpmTag.CHANGELOG_AUTHOR);
                if (changeLogAuthors != null) {
                    artifact.set("Changelog Authors", Arrays.stream(changeLogAuthors).collect(Collectors.joining("\n")));
                }
            }
            return artifact;
        }
        catch (IOException e) {
            return null;
        }
    }
}

